/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.CassandraDirectDataTransportContext;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CassandraCloudStorageTransportContext;
import org.jetbrains.annotations.NotNull;

public enum DataTransport implements TransportContext.TransportContextProvider
{
    DIRECT{

        @Override
        public TransportContext createContext(@NotNull BulkWriterContext bulkWriterContext, @NotNull BulkSparkConf conf, boolean isOnDriver) {
            return new CassandraDirectDataTransportContext(bulkWriterContext);
        }
    }
    ,
    S3_COMPAT{

        @Override
        public TransportContext createContext(@NotNull BulkWriterContext bulkWriterContext, @NotNull BulkSparkConf conf, boolean isOnDriver) {
            return new CassandraCloudStorageTransportContext(bulkWriterContext, conf, isOnDriver);
        }
    };

}

