/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import o.a.c.sidecar.client.shaded.common.request.data.Digest;
import org.apache.cassandra.bridge.SSTableSummary;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.Bundle;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleNameGenerator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableCollector;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BundleTest {
    @TempDir
    private Path tempFolder;

    BundleTest() {
    }

    @Test
    void testBuildBundleAndDelete() throws Exception {
        Path stagingDir = Files.createDirectories(this.tempFolder.resolve("staging"), new FileAttribute[0]);
        long totalSize = 0L;
        int sstableCount = 3;
        int componentCount = 5;
        ArrayList<SSTableCollector.SSTableFilesAndRange> sourceSSTables = new ArrayList<SSTableCollector.SSTableFilesAndRange>(sstableCount);
        for (int i = 0; i < sstableCount; ++i) {
            sourceSSTables.add(this.mockSSTableFilesAndRange(componentCount, 100L));
            totalSize += 100L;
        }
        HashMap<Path, org.apache.cassandra.spark.common.Digest> fileDigests = new HashMap<Path, org.apache.cassandra.spark.common.Digest>();
        for (SSTableCollector.SSTableFilesAndRange sstable : sourceSSTables) {
            for (Path file : sstable.files) {
                fileDigests.put(file, this.mockDigest(file.getFileName().toString()));
            }
        }
        Bundle bundle = Bundle.builder().bundleSequence(0).sourceSSTables(sourceSSTables).bundleNameGenerator(new BundleNameGenerator("jobId", "sessionId")).bundleStagingDirectory(stagingDir).fileDigests(fileDigests).build();
        Assertions.assertThat((long)bundle.bundleUncompressedSize).isEqualTo(totalSize);
        Assertions.assertThat((BigInteger)bundle.firstToken).isEqualTo((Object)BigInteger.ONE);
        Assertions.assertThat((BigInteger)bundle.endToken).isEqualTo((Object)BigInteger.TEN);
        Assertions.assertThat((Path)bundle.bundleFile).isNotNull();
        Assertions.assertThat((boolean)Files.exists(bundle.bundleFile, new LinkOption[0])).isTrue();
        ZipInputStream zis = new ZipInputStream(new FileInputStream(bundle.bundleFile.toFile()));
        int acutalFilesCount = 0;
        ZipEntry entry = null;
        ObjectMapper objectMapper = new ObjectMapper();
        boolean hasManifest = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((entry = zis.getNextEntry()) != null) {
            ++acutalFilesCount;
            if (!entry.getName().endsWith("manifest.json")) continue;
            hasManifest = true;
            zis.transferTo(baos);
        }
        Assertions.assertThat((boolean)hasManifest).isTrue();
        Map manifest = (Map)objectMapper.readValue(baos.toByteArray(), Map.class);
        this.assertManifestEntries(manifest, sourceSSTables);
        Assertions.assertThat((int)acutalFilesCount).isEqualTo(sstableCount * componentCount + 1);
        bundle.deleteAll();
        Assertions.assertThat((boolean)Files.exists(bundle.bundleFile, new LinkOption[0])).isFalse();
        Assertions.assertThat((boolean)Files.exists(bundle.bundleDirectory, new LinkOption[0])).isFalse();
        long filesCount = Files.list(stagingDir).count();
        Assertions.assertThat((long)filesCount).isEqualTo(0L);
    }

    private void assertManifestEntries(Map manifest, List<SSTableCollector.SSTableFilesAndRange> sourceSSTables) {
        HashMap digests = new HashMap();
        manifest.values().forEach(value -> {
            Map componentsChecksum = (Map)((Map)value).get("components_checksum");
            digests.putAll(componentsChecksum);
        });
        for (SSTableCollector.SSTableFilesAndRange sstable : sourceSSTables) {
            for (Path file : sstable.files) {
                String fileName = file.getFileName().toString();
                ((AbstractStringAssert)Assertions.assertThat((String)((String)((Object)digests.getOrDefault(fileName, (CallSite)((Object)("File: " + fileName + " is not found in manifest")))))).as("The digest in the manifest.json does not match with the filename (test configures filename as digest)", new Object[0])).isEqualTo(fileName);
            }
        }
    }

    private SSTableCollector.SSTableFilesAndRange mockSSTableFilesAndRange(int fileCount, long size) throws Exception {
        SSTableSummary summary = new SSTableSummary(BigInteger.ONE, BigInteger.TEN, UUID.randomUUID().toString());
        ArrayList<Path> paths = new ArrayList<Path>(fileCount);
        for (int i = 0; i < fileCount; ++i) {
            paths.add(Files.createFile(this.tempFolder.resolve(UUID.randomUUID().toString()), new FileAttribute[0]));
        }
        return new SSTableCollector.SSTableFilesAndRange(summary, paths, size);
    }

    private org.apache.cassandra.spark.common.Digest mockDigest(final String checksum) {
        return new org.apache.cassandra.spark.common.Digest(){

            public String value() {
                return checksum;
            }

            public Digest toSidecarDigest() {
                return null;
            }
        };
    }
}

