/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.common.data.RestoreJobSecrets;
import o.a.c.sidecar.client.shaded.common.data.StorageCredentials;
import o.a.c.sidecar.client.shaded.common.request.data.CreateSliceRequestPayload;
import o.a.c.sidecar.client.shaded.common.response.data.RestoreJobSummaryResponsePayload;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.SSTableSummary;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.DataTransport;
import org.apache.cassandra.spark.bulkwriter.DataTransportInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.MockBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.MockTableWriter;
import org.apache.cassandra.spark.bulkwriter.NonValidatingTestSortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.Bundle;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleManifest;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleNameGenerator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleStorageObject;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApiImpl;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageStreamSession;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableCollector;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableLister;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableListerTest;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTablesBundler;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.StorageClient;
import org.apache.cassandra.spark.bulkwriter.token.MultiClusterReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.data.FileSystemSSTable;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.exception.SidecarApiCallException;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportConfiguration;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportExtension;
import org.apache.cassandra.spark.utils.DigestAlgorithm;
import org.apache.cassandra.spark.utils.TemporaryDirectory;
import org.apache.cassandra.spark.utils.XXHash32DigestAlgorithm;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class CloudStorageStreamSessionTest {
    @TempDir
    private Path folder;

    CloudStorageStreamSessionTest() {
    }

    @Test
    void testSendBundles() throws IOException, URISyntaxException {
        UUID jobId = UUID.randomUUID();
        String sessionId = "1-" + String.valueOf(UUID.randomUUID());
        BundleNameGenerator nameGenerator = new BundleNameGenerator(jobId.toString(), sessionId);
        TransportContext.CloudStorageTransportContext transportContext = (TransportContext.CloudStorageTransportContext)Mockito.mock(TransportContext.CloudStorageTransportContext.class);
        TokenRangeMapping<RingInstance> topology = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), 3);
        MockBulkWriterContext bulkWriterContext = new MockBulkWriterContext(topology);
        BulkWriterContext spiedWriterContext = (BulkWriterContext)Mockito.spy((Object)bulkWriterContext);
        MultiClusterReplicaAwareFailureHandler replicaAwareFailureHandler = new MultiClusterReplicaAwareFailureHandler(bulkWriterContext.cluster().getPartitioner());
        Range range = Range.range((Comparable)BigInteger.valueOf(100L), (BoundType)BoundType.OPEN, (Comparable)BigInteger.valueOf(199L), (BoundType)BoundType.CLOSED);
        JobInfo job = (JobInfo)Mockito.mock(JobInfo.class);
        Mockito.when((Object)job.getRestoreJobId()).thenReturn((Object)jobId);
        Mockito.when((Object)job.qualifiedTableName()).thenReturn((Object)new QualifiedTableName("ks", "table1"));
        MockTableWriter tableWriter = new MockTableWriter(this.folder);
        NonValidatingTestSortedSSTableWriter sstableWriter = new NonValidatingTestSortedSSTableWriter(tableWriter, this.folder, (DigestAlgorithm)new XXHash32DigestAlgorithm(), 1);
        DataTransportInfo transportInfo = (DataTransportInfo)Mockito.mock(DataTransportInfo.class);
        Mockito.when((Object)transportInfo.getTransport()).thenReturn((Object)DataTransport.S3_COMPAT);
        Mockito.when((Object)transportInfo.getMaxSizePerBundleInBytes()).thenReturn((Object)5120L);
        Mockito.when((Object)job.transportInfo()).thenReturn((Object)transportInfo);
        Mockito.when((Object)spiedWriterContext.job()).thenReturn((Object)job);
        Mockito.when((Object)job.effectiveSidecarPort()).thenReturn((Object)65055);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Mockito.when((Object)clusterInfo.getTokenRangeMapping(ArgumentMatchers.anyBoolean())).thenReturn(topology);
        Mockito.when((Object)spiedWriterContext.cluster()).thenReturn((Object)clusterInfo);
        StorageTransportConfiguration storageTransportConfiguration = (StorageTransportConfiguration)Mockito.mock(StorageTransportConfiguration.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)transportContext.transportConfiguration()).thenReturn((Object)storageTransportConfiguration);
        StorageTransportExtension transportExtension = (StorageTransportExtension)Mockito.mock(StorageTransportExtension.class);
        Mockito.when((Object)transportContext.transportExtensionImplementation()).thenReturn((Object)transportExtension);
        try (TemporaryDirectory tempDir = new TemporaryDirectory();){
            Path sourceDir = Paths.get(this.getClass().getResource("/data/ks/table1-ea3b3e6b-0d78-4913-89f2-15fcf98711d0").toURI());
            Path outputDir = tempDir.path();
            FileUtils.copyDirectory((File)sourceDir.toFile(), (File)outputDir.toFile());
            Map<Path, Digest> fileDigests = SSTableListerTest.calculateFileDigests(outputDir);
            CassandraBridge bridge = this.generateBridge(outputDir);
            SSTableLister ssTableLister = new SSTableLister(new QualifiedTableName("ks", "table1"), bridge);
            ssTableLister.includeFileDigests(fileDigests);
            SSTablesBundler ssTablesBundler = new SSTablesBundler(outputDir, (SSTableCollector)ssTableLister, nameGenerator, 5120L);
            ssTablesBundler.includeDirectory(outputDir);
            ssTablesBundler.finish();
            ImmutableList bundles = ImmutableList.copyOf((Iterator)ssTablesBundler);
            SidecarClient sidecarClient = (SidecarClient)Mockito.mock(SidecarClient.class);
            StorageClient storageClient = (StorageClient)Mockito.mock(StorageClient.class);
            MockBlobTransferApi blobDataTransferApi = new MockBlobTransferApi(spiedWriterContext.job(), sidecarClient, storageClient);
            Mockito.when((Object)transportContext.dataTransferApi()).thenReturn((Object)blobDataTransferApi);
            Mockito.when((Object)transportContext.transportConfiguration().readAccessConfiguration(null).bucket()).thenReturn((Object)"readBucket");
            CloudStorageStreamSession ss = new CloudStorageStreamSession(spiedWriterContext, (SortedSSTableWriter)sstableWriter, transportContext, sessionId, range, bridge, (ReplicaAwareFailureHandler)replicaAwareFailureHandler, Executors.newSingleThreadExecutor());
            for (Bundle bundle : bundles) {
                ss.sendBundle(bundle, true);
            }
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)ss.createdRestoreSlices()).as("It should create 1 slice per bundle", new Object[0])).hasSize(bundles.size());
            Bundle actualBundle1 = blobDataTransferApi.uploadedBundleManifest.get(BigInteger.valueOf(1L));
            BundleManifest.Entry actualBundle1Entry = actualBundle1.manifestEntry("na-1-big-");
            Assertions.assertThat((BigInteger)actualBundle1Entry.firstToken()).isEqualTo((Object)BigInteger.valueOf(1L));
            Assertions.assertThat((BigInteger)actualBundle1Entry.endToken()).isEqualTo((Object)BigInteger.valueOf(3L));
            Map bundle1ComponentsChecksum = actualBundle1Entry.componentsChecksum();
            Assertions.assertThat((String)((String)bundle1ComponentsChecksum.get("na-1-big-Data.db"))).isEqualTo("f48b39a3");
            Assertions.assertThat((String)((String)bundle1ComponentsChecksum.get("na-1-big-Index.db"))).isEqualTo("ee128018");
            Assertions.assertThat((String)((String)bundle1ComponentsChecksum.get("na-1-big-Summary.db"))).isEqualTo("e2c32c23");
            Assertions.assertThat((String)((String)bundle1ComponentsChecksum.get("na-1-big-Statistics.db"))).isEqualTo("f773fcc6");
            Assertions.assertThat((String)((String)bundle1ComponentsChecksum.get("na-1-big-TOC.txt"))).isEqualTo("7c8ef1f5");
            Assertions.assertThat((String)((String)bundle1ComponentsChecksum.get("na-1-big-Filter.db"))).isEqualTo("72fc4f9c");
            Bundle actualBundle2 = blobDataTransferApi.uploadedBundleManifest.get(BigInteger.valueOf(3L));
            BundleManifest.Entry actualBundle2Entry = actualBundle2.manifestEntry("na-2-big-");
            Assertions.assertThat((BigInteger)actualBundle2Entry.firstToken()).isEqualTo((Object)BigInteger.valueOf(3L));
            Assertions.assertThat((BigInteger)actualBundle2Entry.endToken()).isEqualTo((Object)BigInteger.valueOf(6L));
            Map bundle2ComponentsChecksum = actualBundle2Entry.componentsChecksum();
            Assertions.assertThat((String)((String)bundle2ComponentsChecksum.get("na-2-big-Data.db"))).isEqualTo("f48b39a3");
            Assertions.assertThat((String)((String)bundle2ComponentsChecksum.get("na-2-big-Index.db"))).isEqualTo("ee128018");
            Assertions.assertThat((String)((String)bundle2ComponentsChecksum.get("na-2-big-Summary.db"))).isEqualTo("e2c32c23");
            Assertions.assertThat((String)((String)bundle2ComponentsChecksum.get("na-2-big-Statistics.db"))).isEqualTo("f773fcc6");
            Assertions.assertThat((String)((String)bundle2ComponentsChecksum.get("na-2-big-TOC.txt"))).isEqualTo("7c8ef1f5");
            Assertions.assertThat((String)((String)bundle2ComponentsChecksum.get("na-2-big-Filter.db"))).isEqualTo("72fc4f9c");
        }
    }

    private CassandraBridge generateBridge(Path outputDir) {
        CassandraBridge bridge = (CassandraBridge)Mockito.mock(CassandraBridge.class);
        SSTableSummary summary1 = new SSTableSummary(BigInteger.valueOf(1L), BigInteger.valueOf(3L), "na-1-big-");
        SSTableSummary summary2 = new SSTableSummary(BigInteger.valueOf(3L), BigInteger.valueOf(6L), "na-2-big-");
        FileSystemSSTable ssTable1 = new FileSystemSSTable(outputDir.resolve("na-1-big-Data.db"), false, null);
        FileSystemSSTable ssTable2 = new FileSystemSSTable(outputDir.resolve("na-2-big-Data.db"), false, null);
        Mockito.when((Object)bridge.getSSTableSummary("ks", "table1", (SSTable)ssTable1)).thenReturn((Object)summary1);
        Mockito.when((Object)bridge.getSSTableSummary("ks", "table1", (SSTable)ssTable2)).thenReturn((Object)summary2);
        return bridge;
    }

    public static class MockBlobTransferApi
    extends CloudStorageDataTransferApiImpl {
        Map<BigInteger, Bundle> uploadedBundleManifest = new HashMap<BigInteger, Bundle>();

        MockBlobTransferApi(JobInfo jobInfo, SidecarClient sidecarClient, StorageClient storageClient) {
            super(jobInfo, sidecarClient, storageClient, null);
        }

        public RestoreJobSummaryResponsePayload restoreJobSummary() {
            RestoreJobSummaryResponsePayload payload = (RestoreJobSummaryResponsePayload)Mockito.mock(RestoreJobSummaryResponsePayload.class);
            StorageCredentials credentials = (StorageCredentials)Mockito.mock(StorageCredentials.class);
            Mockito.when((Object)credentials.accessKeyId()).thenReturn((Object)"id");
            Mockito.when((Object)credentials.secretAccessKey()).thenReturn((Object)"key");
            Mockito.when((Object)credentials.sessionToken()).thenReturn((Object)"token");
            Mockito.when((Object)payload.secrets()).thenReturn((Object)new RestoreJobSecrets(credentials, credentials));
            return payload;
        }

        public BundleStorageObject uploadBundle(org.apache.cassandra.spark.transports.storage.StorageCredentials writeCredentials, Bundle bundle) {
            this.uploadedBundleManifest.put(bundle.firstToken, bundle);
            return BundleStorageObject.builder().bundle(bundle).storageObjectChecksum("dummy").storageObjectKey("some_prefix-" + bundle.bundleFile.getFileName().toString()).build();
        }

        public void createRestoreSliceFromExecutor(SidecarInstance sidecarInstance, CreateSliceRequestPayload createSliceRequestPayload) throws SidecarApiCallException {
        }
    }
}

