/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template.directive;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.template.Context;
import org.apache.cayenne.template.directive.Directive;
import org.apache.cayenne.template.parser.ASTExpression;

public class Bind
implements Directive {
    public static final Bind INSTANCE = new Bind();

    @Override
    public void apply(Context context, ASTExpression ... expressions) {
        int scale;
        if (expressions.length < 1) {
            throw new IllegalArgumentException();
        }
        Object value = expressions[0].evaluateAsObject(context);
        String jdbcTypeName = expressions.length < 2 ? null : expressions[1].evaluateAsString(context);
        int n = scale = expressions.length < 3 ? -1 : (int)expressions[2].evaluateAsLong(context);
        if (value instanceof Collection) {
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                this.bindValue(context, it.next(), jdbcTypeName, scale);
                if (!it.hasNext()) continue;
                context.getBuilder().append(',');
            }
        } else {
            this.bindValue(context, value, jdbcTypeName, scale);
        }
    }

    protected void bindValue(Context context, Object value, String jdbcTypeName, int scale) {
        int jdbcType = jdbcTypeName != null ? TypesMapping.getSqlTypeByName(jdbcTypeName) : (value != null ? TypesMapping.getSqlTypeByJava(value.getClass()) : TypesMapping.getSqlTypeByName("NULL"));
        this.processBinding(context, new ParameterBinding(value, jdbcType, scale));
    }

    protected void processBinding(Context context, ParameterBinding binding) {
        context.addParameterBinding(binding);
        context.getBuilder().append('?');
    }
}

