/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjAttribute;

public class EmbeddedResult {
    private final Map<String, String> fields;
    private final Embeddable embeddable;

    public EmbeddedResult(Embeddable embeddable, int size) {
        this.embeddable = embeddable;
        this.fields = new HashMap<String, String>((int)Math.ceil((double)size / 0.75));
    }

    public void addAttribute(ObjAttribute attr) {
        this.fields.put(attr.getDbAttributePath(), EmbeddedResult.getAttributeName(attr));
    }

    private static String getAttributeName(ObjAttribute attr) {
        String name = attr.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public Embeddable getEmbeddable() {
        return this.embeddable;
    }
}

