/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.DigraphIteration;
import org.objectstyle.ashwood.graph.FilterArcIterator;
import org.objectstyle.ashwood.graph.GraphUtils;

public class FilterIteration
implements DigraphIteration,
Serializable {
    private DigraphIteration digraph;
    private Predicate acceptVertex;
    private Predicate acceptArc;

    public FilterIteration(DigraphIteration digraph, Predicate acceptVertex, Predicate acceptArc) {
        this.digraph = digraph;
        this.acceptVertex = acceptVertex;
        this.acceptArc = acceptArc;
    }

    public Iterator vertexIterator() {
        return IteratorUtils.filteredIterator((Iterator)this.digraph.vertexIterator(), (Predicate)this.acceptVertex);
    }

    public ArcIterator arcIterator() {
        return new FilterArcIterator(this.digraph.arcIterator(), this.acceptVertex, this.acceptVertex, this.acceptArc);
    }

    public ArcIterator outgoingIterator(Object vertex) {
        if (!this.acceptVertex.evaluate(vertex)) {
            return ArcIterator.EMPTY_ITERATOR;
        }
        return new FilterArcIterator(this.digraph.outgoingIterator(vertex), GraphUtils.TRUE_PREDICATE, this.acceptVertex, this.acceptArc);
    }

    public ArcIterator incomingIterator(Object vertex) {
        if (!this.acceptVertex.evaluate(vertex)) {
            return ArcIterator.EMPTY_ITERATOR;
        }
        return new FilterArcIterator(this.digraph.incomingIterator(vertex), this.acceptVertex, GraphUtils.TRUE_PREDICATE, this.acceptArc);
    }
}

