/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.TransformIterator;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.BreadthFirstSearch;
import org.objectstyle.ashwood.graph.DepthFirstSearch;
import org.objectstyle.ashwood.graph.DepthFirstStampSearch;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.DigraphIteration;
import org.objectstyle.ashwood.graph.LoopSearch;
import org.objectstyle.ashwood.graph.ReversedIteration;
import org.objectstyle.ashwood.graph.TransformArcIterator;
import org.objectstyle.ashwood.predicate.ConstPredicate;
import org.objectstyle.ashwood.util.MutableInteger;

public class GraphUtils {
    public static final Predicate TRUE_PREDICATE = ConstPredicate.TRUE;
    public static final Predicate FALSE_PREDICATE = ConstPredicate.FALSE;

    private GraphUtils() {
    }

    public static boolean isConnected(DigraphIteration digraph, Object firstVertex, int order) {
        DepthFirstSearch dfs = new DepthFirstSearch(digraph, firstVertex);
        return order == GraphUtils.traverse(dfs);
    }

    public static boolean isConnected(Digraph digraph) {
        return GraphUtils.isConnected(digraph, digraph.vertexIterator().next(), digraph.order());
    }

    public static boolean isStronglyConnected(DigraphIteration digraph, Object firstVertex, int order) {
        return GraphUtils.isConnected(digraph, firstVertex, order) && GraphUtils.isConnected(new ReversedIteration(digraph), firstVertex, order);
    }

    public static boolean isStronglyConnected(Digraph digraph) {
        return GraphUtils.isStronglyConnected(digraph, digraph.vertexIterator().next(), digraph.order());
    }

    public static int traverse(Iterator iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static boolean hasLoops(Digraph digraph) {
        return GraphUtils.traverse(new LoopSearch(digraph)) != 0;
    }

    public static boolean isAcyclic(Digraph digraph) {
        int order = digraph.order();
        if (order == 0) {
            return true;
        }
        HashSet spanned = new HashSet(order);
        DepthFirstStampSearch dfs = new DepthFirstStampSearch(digraph, digraph.vertexIterator().next());
        Iterator i = digraph.vertexIterator();
        while (i.hasNext()) {
            Object dfsRoot = i.next();
            if (spanned.contains(dfsRoot)) continue;
            dfs.reset(dfsRoot);
            Map dfsOrders = dfs.traverse(new HashMap(digraph.order()));
            for (Map.Entry entry : dfsOrders.entrySet()) {
                Object origin = entry.getKey();
                DepthFirstStampSearch.OrderPair orgOrders = (DepthFirstStampSearch.OrderPair)entry.getValue();
                spanned.add(origin);
                ArcIterator k = digraph.outgoingIterator(origin);
                while (k.hasNext()) {
                    k.next();
                    Object dst = k.getDestination();
                    DepthFirstStampSearch.OrderPair dstOrders = (DepthFirstStampSearch.OrderPair)dfsOrders.get(dst);
                    if (dstOrders.getPostOrder() <= orgOrders.getPostOrder()) continue;
                    return false;
                }
            }
            if (dfsOrders.size() != order) continue;
            break;
        }
        return true;
    }

    public static Digraph randomize(Digraph digraph, int order, int size, Random randomizer) {
        for (int i = 1; i <= order; ++i) {
            digraph.addVertex(new Integer(i));
        }
        Random random = randomizer;
        int n_2 = order * order;
        size = Math.min(size, n_2);
        for (int arc = 1; arc <= size; ++arc) {
            int arcCode = random.nextInt(n_2);
            int origin = arcCode / order + 1;
            int dst = arcCode % order + 1;
            digraph.putArc(new Integer(origin), new Integer(dst), new Integer(arc));
        }
        return digraph;
    }

    public static Digraph randomizeAcyclic(Digraph digraph, int order, int incomingSize, int outgoingSize, Random randomizer) {
        Random random = randomizer;
        int arc = 1;
        for (int i = 1; i <= order; ++i) {
            Integer destination = new Integer(i);
            digraph.addVertex(destination);
            for (int j = 0; j < incomingSize; ++j) {
                Integer origin;
                int org = random.nextInt(i);
                if (org == 0 || digraph.outgoingSize(origin = new Integer(org)) >= outgoingSize) continue;
                digraph.putArc(origin, destination, new Integer(arc++));
            }
        }
        return digraph;
    }

    public static Digraph randomizeTree(Digraph digraph, int maxChildren, int maxLevels, Random randomizer) {
        int vertexIndex = 1;
        Integer root = new Integer(vertexIndex);
        List<Integer> level = Collections.singletonList(root);
        digraph.addVertex(root);
        for (int i = 1; i < maxLevels; ++i) {
            ArrayList<Integer> childLevel = new ArrayList<Integer>(level.size() * maxChildren);
            for (Integer parent : level) {
                int childCount = randomizer.nextInt(maxChildren + 1);
                for (int k = 0; k < childCount; ++k) {
                    Integer child = new Integer(++vertexIndex);
                    digraph.addVertex(child);
                    digraph.putArc(parent, child, Boolean.TRUE);
                    childLevel.add(child);
                }
            }
            if (childLevel.isEmpty()) break;
            level = childLevel;
        }
        return digraph;
    }

    public static Digraph transform(Digraph result, DigraphIteration source, Transformer vertexTransform, Transformer arcTransform) {
        Object i = new TransformIterator(source.vertexIterator(), vertexTransform);
        while (i.hasNext()) {
            result.addVertex(i.next());
        }
        i = new TransformArcIterator(source.arcIterator(), vertexTransform, arcTransform);
        while (i.hasNext()) {
            Object arc = i.next();
            Object origin = i.getOrigin();
            Object dst = i.getDestination();
            result.putArc(origin, dst, arc);
        }
        return result;
    }

    public static Digraph merge(Digraph destination, DigraphIteration graphToMerge) {
        Iterator i = graphToMerge.vertexIterator();
        while (i.hasNext()) {
            destination.addVertex(i.next());
        }
        i = graphToMerge.arcIterator();
        while (i.hasNext()) {
            Object arc = i.next();
            Object origin = i.getOrigin();
            Object dst = i.getDestination();
            destination.putArc(origin, dst, arc);
        }
        return destination;
    }

    public static Map computeLevels(Map vertexLevelMap, Digraph digraph, boolean longest) {
        if (vertexLevelMap == null) {
            vertexLevelMap = new HashMap(digraph.order());
        }
        Iterator i = digraph.vertexIterator();
        while (i.hasNext()) {
            Object rootCandidate = i.next();
            if (digraph.incomingSize(rootCandidate) != 0) continue;
            GraphUtils.computeLevels(vertexLevelMap, digraph, rootCandidate, longest);
        }
        return vertexLevelMap;
    }

    public static Map computeLevels(Map vertexLevelMap, DigraphIteration digraph, Object root, boolean longest) {
        MutableInteger rootLevel;
        if (vertexLevelMap == null) {
            vertexLevelMap = new HashMap<Object, MutableInteger>();
        }
        if ((rootLevel = (MutableInteger)vertexLevelMap.get(root)) == null) {
            rootLevel = new MutableInteger(0);
            vertexLevelMap.put(root, rootLevel);
        }
        ArcIterator i = digraph.outgoingIterator(root);
        while (i.hasNext()) {
            i.next();
            Object child = i.getDestination();
            int childLevelCandidate = rootLevel.intValue() + 1;
            MutableInteger childLevel = (MutableInteger)vertexLevelMap.get(child);
            if (childLevel == null) {
                childLevel = new MutableInteger(childLevelCandidate);
                vertexLevelMap.put(child, childLevel);
                GraphUtils.computeLevels(vertexLevelMap, digraph, child, longest);
                continue;
            }
            if ((!longest || childLevel.intValue() >= childLevelCandidate) && (longest || childLevel.intValue() <= childLevelCandidate)) continue;
            childLevel.setValue(childLevelCandidate);
            GraphUtils.computeLevels(vertexLevelMap, digraph, child, longest);
        }
        return vertexLevelMap;
    }

    public static Map shiftLevelsDown(Map vertexLevelMap, Digraph digraph) {
        Iterator i = digraph.vertexIterator();
        while (i.hasNext()) {
            Object rootCandidate = i.next();
            if (digraph.incomingSize(rootCandidate) != 0) continue;
            GraphUtils.shiftLevelsDown(vertexLevelMap, digraph, rootCandidate);
        }
        return vertexLevelMap;
    }

    public static Map shiftLevelsDown(Map vertexLevelMap, DigraphIteration digraph, Object root) {
        int minChildLevel = Integer.MAX_VALUE;
        ArcIterator i = digraph.outgoingIterator(root);
        while (i.hasNext()) {
            i.next();
            Object child = i.getDestination();
            GraphUtils.shiftLevelsDown(vertexLevelMap, digraph, child);
            MutableInteger childLevel = (MutableInteger)vertexLevelMap.get(child);
            minChildLevel = minChildLevel <= childLevel.intValue() ? minChildLevel : childLevel.intValue();
        }
        if (minChildLevel != Integer.MAX_VALUE) {
            MutableInteger rootLevel = (MutableInteger)vertexLevelMap.get(root);
            rootLevel.setValue(minChildLevel - 1);
        }
        return vertexLevelMap;
    }

    public static boolean isTree(Digraph digraph) {
        Object root = null;
        Iterator i = digraph.vertexIterator();
        while (i.hasNext()) {
            Object vertex = i.next();
            int inSize = digraph.incomingSize(vertex);
            if (inSize != 0) continue;
            root = vertex;
            break;
        }
        if (root == null) {
            return false;
        }
        BreadthFirstSearch traversal = new BreadthFirstSearch((DigraphIteration)digraph, (Object)root);
        while (traversal.isValidTree() && traversal.hasNext()) {
            traversal.next();
        }
        if (!traversal.isValidTree()) {
            return false;
        }
        Set seenVertices = traversal.getSeenVertices();
        Iterator i2 = digraph.vertexIterator();
        while (i2.hasNext()) {
            if (seenVertices.contains(i2.next())) continue;
            return false;
        }
        return true;
    }

    public static List findCycles(DigraphIteration graph) {
        ArrayStack stack = new ArrayStack();
        ArrayStack path = new ArrayStack();
        HashSet<Object> seen = new HashSet<Object>();
        ArrayList cycles = new ArrayList();
        Iterator vertexIterator = graph.vertexIterator();
        while (vertexIterator.hasNext()) {
            while (vertexIterator.hasNext()) {
                Object vertex = vertexIterator.next();
                if (!seen.add(vertex)) continue;
                stack.push((Object)graph.outgoingIterator(vertex));
                path.push(vertex);
                break;
            }
            while (!stack.isEmpty()) {
                ArcIterator i = (ArcIterator)stack.peek();
                Object origin = i.getOrigin();
                boolean subtreeIsTraversed = true;
                while (i.hasNext()) {
                    i.next();
                    Object dst = i.getDestination();
                    int index = path.indexOf(dst);
                    if (index < 0) {
                        seen.add(dst);
                        stack.push((Object)graph.outgoingIterator(dst));
                        path.push(dst);
                        subtreeIsTraversed = false;
                        break;
                    }
                    cycles.add(new ArrayList(path.subList(index, path.size())));
                }
                if (!subtreeIsTraversed) continue;
                stack.pop();
                path.pop();
            }
        }
        return cycles;
    }
}

