/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.MapDigraph;
import org.objectstyle.ashwood.graph.layout.ArcStraightener;
import org.objectstyle.ashwood.graph.layout.Layer;
import org.objectstyle.ashwood.graph.layout.LayerVertex;
import org.objectstyle.ashwood.graph.layout.NestedSubgraph;
import org.objectstyle.ashwood.graph.layout.RankFunction;
import org.objectstyle.ashwood.graph.layout.SubgraphPartition;
import org.objectstyle.ashwood.util.Attribute;
import org.objectstyle.ashwood.util.IntPartition;

public class DefaultLayerPartition {
    private Layer[] layers;
    private RankFunction rankFunction;
    private IntPartition[] layerPartitions;
    private double horizontalSpacing = 1.0;
    private double verticalSpacing = 1.0;
    private int verticalAlignment = 0;
    private boolean alternatePendulumTraversals = false;
    private double rubberForceThreshold = 1.0;
    private Digraph longArcDigraph;
    private SubgraphPartition subgraphPartition;
    private boolean dummyFixed;

    public DefaultLayerPartition(Digraph digraph, RankFunction rankFunction, Attribute vertexShape, Set[] subgraphPartition) {
        this.createLayers(digraph, rankFunction, vertexShape, subgraphPartition);
    }

    public Layer getLayer(int rank) {
        return this.layers[rank];
    }

    public Object getUserVertex(int rank, int index) {
        return this.layers[rank].getUserVertex(index);
    }

    public void sort(int rank, Comparator comparator) {
        this.layers[rank].sort(comparator);
    }

    public void sort(int rank) {
        this.sort(rank, ComparatorUtils.NATURAL_COMPARATOR);
    }

    public void sortDownByMedian() {
        if (this.subgraphPartition != null) {
            this.subgraphPartition.groupVertices(this.layers[0]);
        }
        for (int rank = 1; rank < this.layers.length; ++rank) {
            Layer layer = this.layers[rank];
            for (int j = 0; j < layer.size(); ++j) {
                LayerVertex v = layer.getVertex(j);
                v.predecessorMedianValue();
            }
            this.sort(rank);
            if (this.subgraphPartition == null) continue;
            this.subgraphPartition.groupVertices(layer);
        }
        if (this.subgraphPartition != null) {
            this.subgraphPartition.untwineSubgraphs(this.layers);
        }
    }

    public void sortUpByMedian() {
        if (this.subgraphPartition != null) {
            this.subgraphPartition.groupVertices(this.layers[this.layers.length - 1]);
        }
        for (int rank = this.layers.length - 2; rank >= 0; --rank) {
            Layer layer = this.layers[rank];
            for (int j = 0; j < layer.size(); ++j) {
                LayerVertex v = (LayerVertex)layer.get(j);
                v.successorMedianValue();
            }
            this.sort(rank);
            if (this.subgraphPartition == null) continue;
            this.subgraphPartition.groupVertices(layer);
        }
        if (this.subgraphPartition != null) {
            this.subgraphPartition.untwineSubgraphs(this.layers);
        }
    }

    public void breadthFirstSort() {
        UnboundedFifoBuffer queue = new UnboundedFifoBuffer();
        HashSet seen = new HashSet();
        queue.addAll((Collection)this.layers[0]);
        seen.addAll(this.layers[0]);
        int[] indices = new int[this.layers.length];
        while (!queue.isEmpty()) {
            LayerVertex origin = (LayerVertex)queue.remove();
            int n = origin.getRank();
            int n2 = indices[n];
            indices[n] = n2 + 1;
            origin.setIndexInLayer(n2);
            for (int i = 0; i < origin.outDegree(); ++i) {
                Object dst = origin.getSuccessors().get(i);
                if (!seen.add(dst)) continue;
                queue.add(dst);
            }
        }
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i].sort();
        }
    }

    public int countCrossings(int rank) {
        if (rank == this.layers.length - 1) {
            return 0;
        }
        Layer layer = this.layers[rank];
        int count = 0;
        int layerSize = layer.size();
        for (int i = 0; i < layerSize - 1; ++i) {
            LayerVertex wrapper = layer.getVertex(i);
            int[] succIndices = wrapper.getSuccessorIndices();
            for (int j = i + 1; j < layerSize; ++j) {
                LayerVertex rightNeighbor = layer.getVertex(j);
                count += rightNeighbor.countLeftCrossings(succIndices);
            }
        }
        return count;
    }

    public int countCrossings() {
        int count = 0;
        for (int i = 0; i < this.layers.length - 1; ++i) {
            count += this.countCrossings(i);
        }
        return count;
    }

    public int getMaxRank() {
        return this.layers.length - 1;
    }

    public int getRankCount() {
        return this.layers.length;
    }

    private void createLayers(Digraph digraph, RankFunction rankFunction, Attribute vertexShape, Set[] subgraphPartition) {
        this.layers = new Layer[rankFunction.maxRank() + 1];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new Layer();
            this.layers[i].setRank(i);
        }
        HashMap<Object, LayerVertex> vertexMap = new HashMap<Object, LayerVertex>(digraph.order());
        this.longArcDigraph = new MapDigraph();
        Iterator i = digraph.vertexIterator();
        while (i.hasNext()) {
            Object vertex = i.next();
            int rank = rankFunction.intValue(vertex);
            LayerVertex wrapper = (LayerVertex)vertexMap.get(vertex);
            if (wrapper == null) {
                wrapper = new LayerVertex(vertex, digraph.incomingSize(vertex), digraph.outgoingSize(vertex));
                if (vertexShape != null) {
                    wrapper.setGeometry(vertexShape);
                }
                vertexMap.put(vertex, wrapper);
                this.layers[rank].add(wrapper);
            }
            Iterator j = digraph.outgoingIterator(vertex);
            while (j.hasNext()) {
                j.next();
                Object dst = j.getDestination();
                int dstRank = rankFunction.intValue(dst);
                int increment = dstRank - rank;
                LayerVertex dstWrapper = (LayerVertex)vertexMap.get(dst);
                if (dstWrapper == null) {
                    dstWrapper = new LayerVertex(dst, digraph.incomingSize(dst), digraph.outgoingSize(dst));
                    if (vertexShape != null) {
                        dstWrapper.setGeometry(vertexShape);
                    }
                    vertexMap.put(dst, dstWrapper);
                    this.layers[dstRank].add(dstWrapper);
                }
                LayerVertex origin = wrapper;
                for (int k = 1; k < increment; ++k) {
                    LayerVertex dummy = new LayerVertex(null, 1, 1);
                    if (k == 1) {
                        this.longArcDigraph.putArc(wrapper, dstWrapper, dummy);
                    }
                    origin.getSuccessors().add(dummy);
                    dummy.getPredecessors().add(origin);
                    this.layers[rank + k].add(dummy);
                    origin = dummy;
                }
                origin.getSuccessors().add(dstWrapper);
                dstWrapper.getPredecessors().add(origin);
            }
        }
        if (subgraphPartition != null && subgraphPartition.length > 0) {
            NestedSubgraph root = new NestedSubgraph();
            root.setLabel("r");
            this.subgraphPartition = new SubgraphPartition();
            for (int i2 = 0; i2 < subgraphPartition.length; ++i2) {
                Set subgraph = subgraphPartition[i2];
                NestedSubgraph nestedSubgraph = new NestedSubgraph(subgraph.size());
                nestedSubgraph.setLabel(String.valueOf(i2));
                for (Object vertex : subgraph) {
                    LayerVertex v = (LayerVertex)vertexMap.get(vertex);
                    nestedSubgraph.add(v);
                }
                root.add(nestedSubgraph);
            }
            ArcIterator i3 = this.longArcDigraph.arcIterator();
            while (i3.hasNext()) {
                LayerVertex dummy = (LayerVertex)i3.next();
                LayerVertex origin = (LayerVertex)i3.getOrigin();
                LayerVertex dst = (LayerVertex)i3.getDestination();
                NestedSubgraph subgraph = origin.getParentSubgraph();
                if (subgraph == null || subgraph != dst.getParentSubgraph()) continue;
                do {
                    subgraph.add(dummy);
                } while ((dummy = (LayerVertex)dummy.getSuccessors().get(0)) != dst);
            }
            for (int i4 = 0; i4 < this.layers.length; ++i4) {
                Layer layer = this.layers[i4];
                for (int j = 0; j < layer.size(); ++j) {
                    LayerVertex v = layer.getVertex(j);
                    if (v.getParentSubgraph() != null) continue;
                    root.add(v);
                }
            }
            this.subgraphPartition.setPartition(root);
        }
    }

    public Map makeOrderSnapshot() {
        HashMap<LayerVertex, Integer> snapshot = new HashMap<LayerVertex, Integer>();
        for (int i = 0; i < this.layers.length; ++i) {
            Layer layer = this.layers[i];
            for (int j = 0; j < layer.size(); ++j) {
                LayerVertex v = layer.getVertex(j);
                snapshot.put(v, new Integer(v.getIndexInLayer()));
            }
        }
        return snapshot;
    }

    public void restoreOrder(Map orderSnapshot) {
        for (int i = 0; i < this.layers.length; ++i) {
            Layer layer = this.layers[i];
            for (int j = 0; j < layer.size(); ++j) {
                LayerVertex v = layer.getVertex(j);
                v.setIndexInLayer(orderSnapshot.get(v).hashCode());
            }
            layer.sort();
        }
    }

    public void refreshIndices() {
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i].refreshIndices();
        }
    }

    public double balanceMeasure() {
        double value = 0.0;
        int denominator = 0;
        for (int i = 0; i < this.layers.length; ++i) {
            Layer layer = this.layers[i];
            for (int j = 0; j < layer.size(); ++j) {
                LayerVertex v = layer.getVertex(j);
                value += v.deflection();
                denominator += v.degree();
            }
        }
        if (denominator == 0) {
            return 0.0;
        }
        value = Math.abs(value) / (double)denominator;
        return value;
    }

    private void createLayerPartition(int rank, boolean topDown) {
        IntPartition layerPartition = this.layerPartitions[rank];
        layerPartition.reset();
        LayerVertex leftNeighbor = null;
        double leftForce = Double.NEGATIVE_INFINITY;
        int leftRegionId = -1;
        Layer layer = this.layers[rank];
        for (int i = 0; i < layer.size(); ++i) {
            LayerVertex vertex = (LayerVertex)layer.get(i);
            double force = topDown ? vertex.predecessorPendulumForce() : vertex.successorPendulumForce();
            int regionId = layerPartition.findSetId(i);
            if (!(!vertex.isTouchingToLeft(leftNeighbor, this.horizontalSpacing) || this.dummyFixed && (vertex.isDummy() || leftNeighbor.isDummy()) || !(leftForce * force > 0.0) && leftForce != force)) {
                layerPartition.joinSets(leftRegionId, regionId);
            }
            leftRegionId = layerPartition.findSetId(regionId);
            leftForce = force;
            leftNeighbor = vertex;
        }
    }

    private void joinRegions(int rank, boolean topDown) {
        int regionCount;
        IntPartition layerPartition = this.layerPartitions[rank];
        Layer layer = this.layers[rank];
        int layerSize = layer.size();
        do {
            regionCount = layerPartition.getSetCount();
            double leftNeighborRegionForce = Double.NEGATIVE_INFINITY;
            int leftNeighborRegionId = -1;
            LayerVertex leftNeighborRightmostVertex = null;
            int i = 0;
            while (i < layerSize) {
                LayerVertex rightmostVertex;
                int regionId = layerPartition.findSetId(i);
                int regionSize = 0;
                double regionForce = 0.0;
                LayerVertex leftmostVertex = (LayerVertex)layer.get(i);
                do {
                    rightmostVertex = (LayerVertex)layer.get(i);
                    regionForce += topDown ? rightmostVertex.predecessorPendulumForce() : rightmostVertex.successorPendulumForce();
                    ++regionSize;
                } while (++i < layerSize && regionId == layerPartition.findSetId(i));
                regionForce /= (double)regionSize;
                if (leftmostVertex.isTouchingToLeft(leftNeighborRightmostVertex, this.horizontalSpacing) && (!this.dummyFixed || !leftmostVertex.isDummy() && !leftNeighborRightmostVertex.isDummy()) && (leftNeighborRegionForce >= 0.0 && regionForce <= 0.0 || regionForce >= 0.0 && leftNeighborRegionForce > regionForce || leftNeighborRegionForce < 0.0 && regionForce < leftNeighborRegionForce)) {
                    layerPartition.joinSets(leftNeighborRegionId, regionId);
                }
                leftNeighborRegionForce = regionForce;
                leftNeighborRegionId = layerPartition.findSetId(regionId);
                leftNeighborRightmostVertex = rightmostVertex;
            }
        } while (regionCount > layerPartition.getSetCount());
    }

    private void move(int rank, boolean topDown) {
        IntPartition layerPartition = this.layerPartitions[rank];
        Layer layer = this.layers[rank];
        int layerSize = layer.size();
        int i = 0;
        while (i < layerSize) {
            double minDistance;
            LayerVertex rightmostVertex;
            int regionId = layerPartition.findSetId(i);
            int regionSize = 0;
            double regionForce = 0.0;
            LayerVertex leftmostVertex = (LayerVertex)layer.get(i);
            int leftmostIndex = i;
            do {
                rightmostVertex = (LayerVertex)layer.get(i);
                regionForce += topDown ? rightmostVertex.predecessorPendulumForce() : rightmostVertex.successorPendulumForce();
                ++regionSize;
            } while (++i < layerSize && regionId == layerPartition.findSetId(i));
            int rightmostIndex = i - 1;
            regionForce /= (double)regionSize;
            double moveDistance = 0.0;
            if (regionForce < 0.0) {
                if (leftmostIndex <= 0) {
                    moveDistance = regionForce;
                } else {
                    LayerVertex leftNeighborRightmostVertex = (LayerVertex)layer.get(leftmostIndex - 1);
                    minDistance = this.horizontalSpacing;
                    moveDistance = -Math.min(-regionForce, leftmostVertex.distanceToLeft(leftNeighborRightmostVertex) - minDistance);
                }
            } else if (regionForce > 0.0) {
                if (rightmostIndex >= layerSize - 1) {
                    moveDistance = regionForce;
                } else {
                    LayerVertex rightNeighborLeftmostVertex = (LayerVertex)layer.get(rightmostIndex + 1);
                    minDistance = this.horizontalSpacing;
                    moveDistance = Math.min(regionForce, rightNeighborLeftmostVertex.distanceToLeft(rightmostVertex) - minDistance);
                }
            }
            if (moveDistance == 0.0) continue;
            for (int j = leftmostIndex; j <= rightmostIndex; ++j) {
                LayerVertex vertex = (LayerVertex)layer.get(j);
                if (this.dummyFixed && vertex.isDummy()) continue;
                vertex.moveX(moveDistance);
            }
        }
    }

    private void balanceLayer(int rank, boolean topDown) {
        this.createLayerPartition(rank, topDown);
        this.joinRegions(rank, topDown);
        this.move(rank, topDown);
    }

    public void createSubgraphPartition() {
        if (this.subgraphPartition != null) {
            this.subgraphPartition.insertBorderSegments(this.layers);
        }
    }

    public int balancePendulum(int iterationCount) {
        double balanceMeasure;
        this.layerPartitions = new IntPartition[this.layers.length];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layerPartitions[i] = new IntPartition(this.layers[i].size());
        }
        double newBalanceMeasure = Double.POSITIVE_INFINITY;
        boolean iterations = false;
        boolean topDown = true;
        if (!this.dummyFixed) {
            this.initXPositions();
        }
        int iteration = 0;
        do {
            ++iteration;
            balanceMeasure = newBalanceMeasure;
            int start = topDown ? 1 : this.layers.length - 2;
            int finish = topDown ? this.layers.length : -1;
            int step = topDown ? 1 : -1;
            for (int i = start; i != finish; i += step) {
                this.balanceLayer(i, topDown);
            }
            newBalanceMeasure = this.balanceMeasure();
            if (!this.alternatePendulumTraversals) continue;
            boolean bl = topDown = !topDown;
        } while (newBalanceMeasure < balanceMeasure && iteration <= iterationCount);
        return iteration;
    }

    private void initXPositions() {
        for (int i = 0; i < this.layers.length; ++i) {
            this.initXPositions(i);
        }
    }

    private void initXPositions(int rank) {
        Layer layer = this.layers[rank];
        int layerSize = layer.size();
        double minX = 0.0;
        for (int i = 0; i < layerSize; ++i) {
            LayerVertex vertex = (LayerVertex)layer.get(i);
            vertex.setCenterX(minX + vertex.getWidth() / 2.0);
            minX += vertex.getWidth() + this.horizontalSpacing;
        }
    }

    public int balanceRubberBends(int iterationCount) {
        boolean rubberForceThresholdArchived;
        double balanceMeasure = Double.POSITIVE_INFINITY;
        int iteration = 0;
        do {
            ++iteration;
            rubberForceThresholdArchived = true;
            for (int i = 0; i < this.layers.length; ++i) {
                Layer layer = this.layers[i];
                int layerSize = layer.size();
                double minX = 0.0;
                for (int j = 0; j < layerSize; ++j) {
                    double force;
                    LayerVertex vertex = (LayerVertex)layer.get(j);
                    if (this.dummyFixed && vertex.isDummy() || !(Math.abs(force = vertex.rubberForce()) > this.rubberForceThreshold)) continue;
                    rubberForceThresholdArchived = false;
                    if (force < 0.0) {
                        if (j == 0) {
                            vertex.moveX(force);
                        } else {
                            LayerVertex leftNeighbor = (LayerVertex)layer.get(j - 1);
                            vertex.moveX(-Math.min(-force, vertex.distanceToLeft(leftNeighbor) - this.horizontalSpacing));
                        }
                    } else if (j == layerSize - 1) {
                        vertex.moveX(force);
                    } else {
                        LayerVertex rightNeighbor = (LayerVertex)layer.get(j + 1);
                        vertex.moveX(Math.min(force, rightNeighbor.distanceToLeft(vertex) - this.horizontalSpacing));
                    }
                    double newBalanceMeasure = this.balanceMeasure();
                    if (balanceMeasure <= newBalanceMeasure) {
                        return iteration;
                    }
                    balanceMeasure = newBalanceMeasure;
                }
            }
        } while (!rubberForceThresholdArchived && iteration <= iterationCount);
        return iteration;
    }

    public boolean isAlternatePendulumTraversals() {
        return this.alternatePendulumTraversals;
    }

    public void setAlternatePendulumTraversals(boolean alternatePendulumTraversals) {
        this.alternatePendulumTraversals = alternatePendulumTraversals;
    }

    public double getRubberForceThreshold() {
        return this.rubberForceThreshold;
    }

    public void setRubberForceThreshold(double rubberForceThreshold) {
        this.rubberForceThreshold = rubberForceThreshold;
    }

    public double getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(double horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
    }

    public double getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(double verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
    }

    public void positionLayers() {
        double layerY = 0.0;
        switch (this.verticalAlignment) {
            case 1: {
                for (int i = 0; i < this.layers.length; ++i) {
                    Layer layer = this.layers[i];
                    int layerSize = layer.size();
                    double increment = 0.0;
                    for (int j = 0; j < layerSize; ++j) {
                        LayerVertex vertex = (LayerVertex)layer.get(j);
                        vertex.setCenterY(layerY + vertex.getHeight() / 2.0);
                        increment = Math.max(increment, vertex.getHeight());
                    }
                    layerY += increment + this.verticalSpacing;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.layers.length; ++i) {
                    LayerVertex vertex;
                    int j;
                    Layer layer = this.layers[i];
                    int layerSize = layer.size();
                    double increment = 0.0;
                    for (j = 0; j < layerSize; ++j) {
                        vertex = (LayerVertex)layer.get(j);
                        increment = Math.max(increment, vertex.getHeight());
                    }
                    layerY += increment;
                    for (j = 0; j < layerSize; ++j) {
                        vertex = (LayerVertex)layer.get(j);
                        vertex.setCenterY(layerY - vertex.getHeight() / 2.0);
                    }
                    layerY += this.verticalSpacing;
                }
                break;
            }
            default: {
                for (int i = 0; i < this.layers.length; ++i) {
                    LayerVertex vertex;
                    int j;
                    Layer layer = this.layers[i];
                    int layerSize = layer.size();
                    double increment = 0.0;
                    for (j = 0; j < layerSize; ++j) {
                        vertex = (LayerVertex)layer.get(j);
                        increment = Math.max(increment, vertex.getHeight() / 2.0);
                    }
                    layerY += increment;
                    for (j = 0; j < layerSize; ++j) {
                        vertex = (LayerVertex)layer.get(j);
                        vertex.setCenterY(layerY);
                    }
                    layerY += increment + this.verticalSpacing;
                }
            }
        }
    }

    public void positionDummies() {
        ArcStraightener arcStraightener = new ArcStraightener();
        arcStraightener.positionDummies(this.layers, this.horizontalSpacing);
    }

    public void updateGeometry(Attribute vertexShape, Rectangle2D areaBounds) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.layers.length; ++i) {
            Layer layer = this.layers[i];
            int layerSize = layer.size();
            for (int j = 0; j < layerSize; ++j) {
                LayerVertex vertex = (LayerVertex)layer.get(j);
                minX = Math.min(minX, vertex.getMinX());
                minY = Math.min(minY, vertex.getMinY());
                maxX = Math.max(maxX, vertex.getMaxX());
                maxY = Math.max(maxY, vertex.getMaxY());
                if (vertex.isDummy()) continue;
                vertex.updateGeometry(vertexShape);
            }
        }
        areaBounds.setFrame(minX, minY, maxX - minX, maxY - minY);
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public Digraph positionArcs() {
        MapDigraph arcGeometryDigraph = new MapDigraph();
        ArcIterator i = this.longArcDigraph.arcIterator();
        while (i.hasNext()) {
            LayerVertex dummy = (LayerVertex)i.next();
            LayerVertex origin = (LayerVertex)i.getOrigin();
            LayerVertex dst = (LayerVertex)i.getDestination();
            int pointCount = dst.getRank() - origin.getRank() + 1;
            ArrayList<Point> points = new ArrayList<Point>(pointCount);
            double x1 = origin.getCenterX();
            double x2 = dummy.getCenterX();
            double y1 = origin.getCenterY();
            double y2 = dummy.getCenterY();
            double h = origin.getHeight() / 2.0;
            double x = (x2 - x1) * h / (y2 - y1) + x1;
            double y = y1 + h;
            points.add(new Point((int)x, (int)y));
            LayerVertex successor = dummy;
            int pointIndex = 0;
            do {
                dummy = successor;
                successor = dummy.getSuccessor(0);
                if (pointCount > 4 && ++pointIndex > 1 && pointIndex < pointCount - 2) continue;
                x2 = dummy.getCenterX();
                y2 = dummy.getCenterY();
                if (pointCount >= 4) {
                    if (pointIndex == 1) {
                        y2 -= origin.getHeight() / 2.0;
                    } else if (pointIndex == pointCount - 2) {
                        y2 += dst.getHeight() / 2.0;
                    }
                }
                points.add(new Point((int)x2, (int)y2));
            } while (successor != dst);
            x1 = dst.getCenterX();
            y1 = dst.getCenterY();
            h = dst.getHeight() / 2.0;
            x = (x2 - x1) * h / (y1 - y2) + x1;
            y = y1 - h;
            points.add(new Point((int)x, (int)y));
            arcGeometryDigraph.putArc(origin.getUserVertex(), dst.getUserVertex(), points);
        }
        return arcGeometryDigraph;
    }

    public void setDummyFixed(boolean dummyFixed) {
        this.dummyFixed = dummyFixed;
    }

    public boolean isDummyFixed() {
        return this.dummyFixed;
    }

    public void printLayers() {
        for (int i = 0; i < this.layers.length; ++i) {
            System.out.print("l[" + this.layers[i].getRank() + "]: ");
            for (int j = 0; j < this.layers[i].size(); ++j) {
                LayerVertex v = this.layers[i].getVertex(j);
                String sgLabel = v.getParentSubgraph() != null ? v.getParentSubgraph().getLabel() : "?";
                System.out.print(sgLabel + "." + v + "{" + v.getRank() + "," + v.getIndexInLayer() + "}, ");
            }
            System.out.println();
        }
    }
}

