/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.RawQueryPropertiesPanel;
import org.apache.cayenne.modeler.editor.SelectPropertiesPanel;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class SQLTemplateMainTab
extends JPanel {
    private static final String DEFAULT_CAPS_LABEL = "Database Default";
    private static final String LOWER_CAPS_LABEL = "Force Lower Case";
    private static final String UPPER_CAPS_LABEL = "Force Upper Case";
    private static final CapsStrategy[] LABEL_CAPITALIZATION = new CapsStrategy[]{CapsStrategy.DEFAULT, CapsStrategy.LOWER, CapsStrategy.UPPER};
    private static final Map<CapsStrategy, String> labelCapsLabels = new HashMap<CapsStrategy, String>();
    protected ProjectController mediator;
    protected TextAdapter name;
    protected SelectPropertiesPanel properties;

    public SQLTemplateMainTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                SQLTemplateMainTab.this.setQueryName(text);
            }
        };
        this.properties = new SQLTemplateQueryPropertiesPanel(this.mediator);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, fill:max(200dlu;pref)", "p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("SQLTemplate Settings", cc.xywh(1, 1, 3, 1));
        builder.addLabel("Query Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xy(3, 3));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "North");
        this.add((Component)this.properties, "Center");
    }

    void initFromModel() {
        Query query = this.mediator.getCurrentQuery();
        if (!(query instanceof SQLTemplate)) {
            this.setVisible(false);
            return;
        }
        SQLTemplate sqlQuery = (SQLTemplate)query;
        this.name.setText(sqlQuery.getName());
        this.properties.initFromModel((Query)sqlQuery);
        this.setVisible(true);
    }

    protected SQLTemplate getQuery() {
        Query query = this.mediator.getCurrentQuery();
        return query instanceof SQLTemplate ? (SQLTemplate)query : null;
    }

    void setQueryName(String newName) {
        SQLTemplate query;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((query = this.getQuery()) == null) {
            return;
        }
        if (Util.nullSafeEquals((Object)newName, (Object)query.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Query name is required.");
        }
        DataMap map = this.mediator.getCurrentDataMap();
        if (map.getQuery(newName) != null) {
            throw new ValidationException("There is another query named '" + newName + "'. Use a different name.");
        }
        QueryEvent e = new QueryEvent((Object)this, (Query)query, query.getName());
        ProjectUtil.setQueryName(map, (Query)query, newName);
        this.mediator.fireQueryEvent(e);
    }

    ObjEntity getEntity(SQLTemplate query) {
        return query != null && query.getRoot() instanceof ObjEntity ? (ObjEntity)query.getRoot() : null;
    }

    void setEntity(ObjEntity entity) {
        SQLTemplate template = this.getQuery();
        if (template != null) {
            ObjEntity root = entity != null ? entity : this.mediator.getCurrentDataMap();
            template.setRoot((Object)root);
            this.mediator.fireQueryEvent(new QueryEvent((Object)this, (Query)template));
        }
    }

    static {
        labelCapsLabels.put(CapsStrategy.DEFAULT, DEFAULT_CAPS_LABEL);
        labelCapsLabels.put(CapsStrategy.LOWER, LOWER_CAPS_LABEL);
        labelCapsLabels.put(CapsStrategy.UPPER, UPPER_CAPS_LABEL);
    }

    final class SQLTemplateQueryPropertiesPanel
    extends RawQueryPropertiesPanel {
        private JComboBox labelCase;

        SQLTemplateQueryPropertiesPanel(ProjectController mediator) {
            super(mediator);
        }

        protected PanelBuilder createPanelBuilder() {
            RowSpec[] extraRows;
            this.labelCase = CayenneWidgetFactory.createUndoableComboBox();
            this.labelCase.setRenderer(new LabelCapsRenderer());
            this.labelCase.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Object value = SQLTemplateQueryPropertiesPanel.this.labelCase.getModel().getSelectedItem();
                    SQLTemplateQueryPropertiesPanel.this.setQueryProperty("columnNamesCapitalization", value);
                }
            });
            PanelBuilder builder = super.createPanelBuilder();
            for (RowSpec extraRow : extraRows = RowSpec.decodeSpecs((String)"3dlu, p")) {
                builder.appendRow(extraRow);
            }
            CellConstraints cc = new CellConstraints();
            builder.addLabel("Row Label Case:", cc.xy(1, 17));
            builder.add((Component)this.labelCase, cc.xywh(3, 17, 5, 1));
            return builder;
        }

        public void initFromModel(Query query) {
            super.initFromModel(query);
            if (query instanceof SQLTemplate) {
                SQLTemplate template = (SQLTemplate)query;
                DefaultComboBoxModel<CapsStrategy> labelCaseModel = new DefaultComboBoxModel<CapsStrategy>(LABEL_CAPITALIZATION);
                labelCaseModel.setSelectedItem(template.getColumnNamesCapitalization());
                this.labelCase.setModel(labelCaseModel);
            }
        }

        protected void setEntity(ObjEntity entity) {
            SQLTemplateMainTab.this.setEntity(entity);
        }

        public ObjEntity getEntity(Query query) {
            if (query instanceof SQLTemplate) {
                return SQLTemplateMainTab.this.getEntity((SQLTemplate)query);
            }
            return null;
        }
    }

    final class LabelCapsRenderer
    extends DefaultListCellRenderer {
        LabelCapsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object object, int arg2, boolean arg3, boolean arg4) {
            object = labelCapsLabels.get(object);
            return super.getListCellRendererComponent((JList<?>)list, object, arg2, arg3, arg4);
        }
    }
}

