/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneTableModel;

public class DbRelationshipTableModel
extends CayenneTableModel {
    static final int NAME = 0;
    static final int TARGET = 1;
    static final int TO_DEPENDENT_KEY = 2;
    static final int CARDINALITY = 3;
    protected DbEntity entity;

    public DbRelationshipTableModel(DbEntity entity, ProjectController mediator, Object eventSource) {
        super(mediator, eventSource, new ArrayList(entity.getRelationships()));
        this.entity = entity;
    }

    public Class getElementsClass() {
        return DbRelationship.class;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Target";
            }
            case 2: {
                return "To Dep PK";
            }
            case 3: {
                return "To Many";
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 1: {
                return DbEntity.class;
            }
            case 2: 
            case 3: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public DbRelationship getRelationship(int row) {
        return row >= 0 && row < this.objectList.size() ? (DbRelationship)this.objectList.get(row) : null;
    }

    public Object getValueAt(int row, int col) {
        DbRelationship rel = this.getRelationship(row);
        if (rel == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return rel.getName();
            }
            case 1: {
                return rel.getTargetEntity();
            }
            case 2: {
                return rel.isToDependentPK() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return rel.isToMany() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public void setUpdatedValueAt(Object aValue, int row, int column) {
        DbRelationship rel = this.getRelationship(row);
        if (column == 0) {
            RelationshipEvent e = new RelationshipEvent(this.eventSource, (Relationship)rel, (Entity)this.entity, rel.getName());
            rel.setName((String)aValue);
            this.mediator.fireDbRelationshipEvent(e);
            this.fireTableCellUpdated(row, column);
        } else if (column == 1) {
            DbEntity target = (DbEntity)aValue;
            rel.removeAllJoins();
            rel.setTargetEntity((Entity)target);
            RelationshipEvent e = new RelationshipEvent(this.eventSource, (Relationship)rel, (Entity)this.entity);
            this.mediator.fireDbRelationshipEvent(e);
        } else if (column == 2) {
            DbRelationship reverse;
            boolean flag = (Boolean)aValue;
            if (flag && (reverse = rel.getReverseRelationship()) != null && reverse.isToDependentPK()) {
                String message = "Unset reverse relationship's \"To Dep PK\" setting?";
                int answer = JOptionPane.showConfirmDialog(Application.getFrame(), message);
                if (answer != 0) {
                    return;
                }
                reverse.setToDependentPK(false);
            }
            rel.setToDependentPK(flag);
            RelationshipEvent e = new RelationshipEvent(this.eventSource, (Relationship)rel, (Entity)this.entity);
            this.mediator.fireDbRelationshipEvent(e);
        } else if (column == 3) {
            Boolean temp = (Boolean)aValue;
            rel.setToMany(temp.booleanValue());
            RelationshipEvent e = new RelationshipEvent(this.eventSource, (Relationship)rel, (Entity)this.entity);
            this.mediator.fireDbRelationshipEvent(e);
            this.updateDependentObjRelationships(rel);
        }
        this.fireTableRowsUpdated(row, row);
    }

    void removeRelationship(Relationship rel) {
        this.objectList.remove(rel);
        this.fireTableDataChanged();
    }

    void updateDependentObjRelationships(DbRelationship relationship) {
        DataDomain domain = this.mediator.getCurrentDataDomain();
        if (domain != null) {
            for (ObjEntity entity : domain.getEntityResolver().getObjEntities()) {
                block1: for (ObjRelationship objRelationship : entity.getRelationships()) {
                    for (DbRelationship dbRelationship : objRelationship.getDbRelationships()) {
                        if (dbRelationship != relationship) continue;
                        objRelationship.recalculateToManyValue();
                        objRelationship.recalculateReadOnlyValue();
                        continue block1;
                    }
                }
            }
        }
    }

    public boolean isCellEditable(int row, int col) {
        DbRelationship rel = this.getRelationship(row);
        if (rel == null) {
            return false;
        }
        if (col == 2) {
            return rel.isValidForDepPk();
        }
        return true;
    }
}

