/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.pref;

import java.sql.Driver;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.pref._DBConnectionInfo;
import org.apache.cayenne.util.Util;

public class DBConnectionInfo
extends _DBConnectionInfo {
    public DbAdapter makeAdapter(ClassLoadingService classLoader) throws Exception {
        String adapterClassName = this.getDbAdapter();
        if (adapterClassName == null || AutoAdapter.class.getName().equals(adapterClassName)) {
            return new AutoAdapter(this.makeDataSource(classLoader));
        }
        try {
            return (DbAdapter)classLoader.loadClass(adapterClassName).newInstance();
        }
        catch (Throwable th) {
            th = Util.unwindException((Throwable)th);
            throw new Exception("DbAdapter load error: " + th.getLocalizedMessage());
        }
    }

    public DataSource makeDataSource(ClassLoadingService classLoader) throws SQLException {
        Driver driver;
        if (this.getJdbcDriver() == null) {
            throw new SQLException("No JDBC driver set.");
        }
        if (this.getUrl() == null) {
            throw new SQLException("No DB URL set.");
        }
        try {
            driver = (Driver)classLoader.loadClass(this.getJdbcDriver()).newInstance();
        }
        catch (Throwable th) {
            th = Util.unwindException((Throwable)th);
            throw new SQLException("Driver load error: " + th.getLocalizedMessage());
        }
        return new DriverDataSource(driver, this.getUrl(), this.getUserName(), this.getPassword());
    }

    public boolean copyTo(DBConnectionInfo dataSourceInfo) {
        boolean updated = false;
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getUrl(), (Object)this.getUrl())) {
            dataSourceInfo.setUrl(this.getUrl());
            updated = true;
        }
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getUserName(), (Object)this.getUserName())) {
            dataSourceInfo.setUserName(this.getUserName());
            updated = true;
        }
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getPassword(), (Object)this.getPassword())) {
            dataSourceInfo.setPassword(this.getPassword());
            updated = true;
        }
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getJdbcDriver(), (Object)this.getJdbcDriver())) {
            dataSourceInfo.setJdbcDriver(this.getJdbcDriver());
            updated = true;
        }
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getDbAdapter(), (Object)this.getDbAdapter())) {
            dataSourceInfo.setDbAdapter(this.getDbAdapter());
            updated = true;
        }
        return updated;
    }

    public boolean copyTo(DataSourceInfo dataSourceInfo) {
        boolean updated = false;
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getDataSourceUrl(), (Object)this.getUrl())) {
            dataSourceInfo.setDataSourceUrl(this.getUrl());
            updated = true;
        }
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getUserName(), (Object)this.getUserName())) {
            dataSourceInfo.setUserName(this.getUserName());
            updated = true;
        }
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getPassword(), (Object)this.getPassword())) {
            dataSourceInfo.setPassword(this.getPassword());
            updated = true;
        }
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getJdbcDriver(), (Object)this.getJdbcDriver())) {
            dataSourceInfo.setJdbcDriver(this.getJdbcDriver());
            updated = true;
        }
        return updated;
    }

    public boolean copyFrom(DataSourceInfo dataSourceInfo) {
        boolean updated = false;
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getDataSourceUrl(), (Object)this.getUrl())) {
            this.setUrl(dataSourceInfo.getDataSourceUrl());
            updated = true;
        }
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getUserName(), (Object)this.getUserName())) {
            this.setUserName(dataSourceInfo.getUserName());
            updated = true;
        }
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getPassword(), (Object)this.getPassword())) {
            this.setPassword(dataSourceInfo.getPassword());
            updated = true;
        }
        if (!Util.nullSafeEquals((Object)dataSourceInfo.getJdbcDriver(), (Object)this.getJdbcDriver())) {
            this.setJdbcDriver(dataSourceInfo.getJdbcDriver());
            updated = true;
        }
        return updated;
    }
}

