/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.pref.PreferenceDetail;
import org.apache.cayenne.pref.PreferenceException;
import org.apache.cayenne.pref._DomainPreference;
import org.apache.cayenne.util.Util;

public class DomainPreference
extends _DomainPreference {
    protected DomainProperties properties;

    protected Properties getProperties() {
        if (this.properties == null) {
            this.properties = new DomainProperties();
            String values = this.getKeyValuePairs();
            if (values != null && values.length() > 0) {
                try {
                    this.properties.load(new ByteArrayInputStream(values.getBytes()));
                }
                catch (IOException ex) {
                    throw new PreferenceException("Error loading properties.", ex);
                }
            }
        }
        return this.properties;
    }

    protected void encodeProperties() {
        if (this.properties == null) {
            this.setKeyValuePairs(null);
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.properties.store(out, null);
            }
            catch (IOException ex) {
                throw new PreferenceException("Error storing properties.", ex);
            }
            this.setKeyValuePairs(out.toString());
        }
    }

    protected PreferenceDetail getPreference() {
        PreferenceDetail preference = new PreferenceDetail();
        preference.setDomainPreference(this);
        return preference;
    }

    protected PreferenceDetail getPreference(Class javaClass, boolean create) {
        int pk = DataObjectUtils.intPKForObject((Persistent)this);
        PreferenceDetail preference = (PreferenceDetail)((Object)DataObjectUtils.objectForPK((ObjectContext)this.getObjectContext(), (Class)javaClass, (int)pk));
        if (preference != null) {
            preference.setDomainPreference(this);
        }
        if (preference != null || !create) {
            return preference;
        }
        preference = (PreferenceDetail)((Object)this.getObjectContext().newObject(javaClass));
        preference.setDomainPreference(this);
        this.getObjectContext().commitChanges();
        return preference;
    }

    public void setPersistenceState(int state) {
        if (state == 5) {
            this.properties = null;
        }
        super.setPersistenceState(state);
    }

    class DomainProperties
    extends Properties {
        DomainProperties() {
        }

        public Object setProperty(String key, String value) {
            Object old = super.setProperty(key, value);
            if (!Util.nullSafeEquals((Object)old, (Object)value)) {
                this.modified();
            }
            return old;
        }

        void modified() {
            DomainPreference.this.encodeProperties();
        }
    }
}

