/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import foundrylogic.vpp.VPPConfig;
import java.io.Writer;
import java.util.Properties;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.gen.ClassGenerationInfo;
import org.apache.cayenne.gen.ClassGeneratorResourceLoader;
import org.apache.cayenne.gen.EntityUtils;
import org.apache.cayenne.gen.ImportUtils;
import org.apache.cayenne.gen.StringUtils;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogSystem;

public class ClassGenerator {
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    protected String versionString;
    protected Template classTemplate;
    protected Context velCtxt;
    protected ClassGenerationInfo classGenerationInfo;

    public ClassGenerator(String template, String versionString) throws Exception {
        this.versionString = versionString;
        if (!VERSION_1_1.equals(versionString)) {
            throw new IllegalStateException("Illegal Version in generateClass(Writer,ObjEntity): " + versionString);
        }
        this.velCtxt = new VelocityContext();
        this.classGenerationInfo = new ClassGenerationInfo();
        this.velCtxt.put("classGen", this.classGenerationInfo);
        this.initializeClassTemplate(template);
    }

    public ClassGenerator(String template, String versionString, VPPConfig vppConfig) throws Exception {
        this.versionString = versionString;
        if (!VERSION_1_2.equals(versionString)) {
            throw new IllegalStateException("Illegal Version in generateClass(Writer,ObjEntity): " + versionString);
        }
        this.velCtxt = vppConfig != null ? vppConfig.getVelocityContext() : new VelocityContext();
        this.initializeClassTemplate(template);
    }

    private void initializeClassTemplate(String template) throws CayenneRuntimeException {
        VelocityEngine velocityEngine = new VelocityEngine();
        try {
            Properties props = new Properties();
            props.put("runtime.log.logsystem.class", NullLogSystem.class.getName());
            props.put("resource.loader", "cayenne");
            props.put("cayenne.resource.loader.class", ClassGeneratorResourceLoader.class.getName());
            velocityEngine.init(props);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Can't initialize Velocity", ex);
        }
        try {
            this.classTemplate = velocityEngine.getTemplate(template);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Can't create template: " + template, ex);
        }
    }

    public void generateClass(Writer out, ObjEntity entity) throws Exception {
        if (!VERSION_1_1.equals(this.versionString)) {
            throw new IllegalStateException("Illegal Version in generateClass(Writer,ObjEntity): " + this.versionString);
        }
        this.classGenerationInfo.setObjEntity(entity);
        this.classTemplate.merge(this.velCtxt, out);
    }

    public void generateClass(Writer out, DataMap dataMap, ObjEntity entity, String fqnBaseClass, String fqnSuperClass, String fqnSubClass) throws Exception {
        if (!VERSION_1_2.equals(this.versionString)) {
            throw new IllegalStateException("Illegal Version in generateClass(Writer,ObjEntity,String,String,String): " + this.versionString);
        }
        if (null == dataMap) {
            throw new IllegalStateException("DataMap MapClassGenerator constructor required for v1.2 templating.");
        }
        this.velCtxt.put("objEntity", entity);
        this.velCtxt.put("stringUtils", StringUtils.getInstance());
        this.velCtxt.put("entityUtils", new EntityUtils(dataMap, entity, fqnBaseClass, fqnSuperClass, fqnSubClass));
        this.velCtxt.put("importUtils", new ImportUtils());
        this.classTemplate.merge(this.velCtxt, out);
    }

    public ClassGenerationInfo getClassGenerationInfo() {
        return this.classGenerationInfo;
    }
}

