/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datadomain;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.modeler.dialog.datadomain.CacheSyncConfigModel;
import org.scopemvc.core.Selector;

public class JGroupsConfigModel
extends CacheSyncConfigModel {
    private static final String[] storedProperties = new String[]{"cayenne.DataRowStore.EventBridge.factory", "cayenne.JavaGroupsBridge.mcast.address", "cayenne.JavaGroupsBridge.mcast.port", "javagroupsbridge.config.url"};
    private static Map selectors;
    private static Map defaults;
    public static final Selector USING_CONFIG_FILE_SELECTOR;
    public static final Selector USING_DEFAULT_CONFIG_SELECTOR;
    public static final Selector MCAST_ADDRESS_SELECTOR;
    public static final Selector MCAST_PORT_SELECTOR;
    public static final Selector JGROUPS_CONFIG_URL_SELECTOR;
    protected boolean usingConfigFile;

    public void setMap(Map map) {
        super.setMap(map);
        this.usingConfigFile = map != null && this.getJgroupsConfigURL() != null;
    }

    public Selector selectorForKey(String key) {
        return (Selector)selectors.get(key);
    }

    public String defaultForKey(String key) {
        return (String)defaults.get(key);
    }

    public boolean isUsingConfigFile() {
        return this.usingConfigFile;
    }

    public String[] supportedProperties() {
        return storedProperties;
    }

    public void setUsingConfigFile(boolean b) {
        this.usingConfigFile = b;
        if (b) {
            this.setMcastAddress(null);
            this.setMcastPort(null);
        } else {
            this.setJgroupsConfigURL(null);
        }
    }

    public boolean isUsingDefaultConfig() {
        return !this.isUsingConfigFile();
    }

    public void setUsingDefaultConfig(boolean flag) {
        this.setUsingConfigFile(!flag);
    }

    public String getJgroupsConfigURL() {
        return this.getProperty("javagroupsbridge.config.url");
    }

    public void setJgroupsConfigURL(String jgroupsConfigURL) {
        this.setProperty("javagroupsbridge.config.url", jgroupsConfigURL);
    }

    public String getMcastAddress() {
        return this.getProperty("cayenne.JavaGroupsBridge.mcast.address");
    }

    public void setMcastAddress(String multicastAddress) {
        this.setProperty("cayenne.JavaGroupsBridge.mcast.address", multicastAddress);
    }

    public String getMcastPort() {
        return this.getProperty("cayenne.JavaGroupsBridge.mcast.port");
    }

    public void setMcastPort(String multicastPort) {
        this.setProperty("cayenne.JavaGroupsBridge.mcast.port", multicastPort);
    }

    static {
        USING_CONFIG_FILE_SELECTOR = Selector.fromString("usingConfigFile");
        USING_DEFAULT_CONFIG_SELECTOR = Selector.fromString("usingDefaultConfig");
        MCAST_ADDRESS_SELECTOR = Selector.fromString("mcastAddress");
        MCAST_PORT_SELECTOR = Selector.fromString("mcastPort");
        JGROUPS_CONFIG_URL_SELECTOR = Selector.fromString("jgroupsConfigURL");
        selectors = new HashMap(5);
        selectors.put("javagroupsbridge.config.url", JGROUPS_CONFIG_URL_SELECTOR);
        selectors.put("cayenne.JavaGroupsBridge.mcast.address", MCAST_ADDRESS_SELECTOR);
        selectors.put("cayenne.JavaGroupsBridge.mcast.port", MCAST_PORT_SELECTOR);
        defaults = new HashMap(4);
        defaults.put("cayenne.JavaGroupsBridge.mcast.address", "228.0.0.5");
        defaults.put("cayenne.JavaGroupsBridge.mcast.port", "22222");
    }
}

