/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.List;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.AbstractRemoveCallbackMethodAction;
import org.apache.cayenne.modeler.action.CreateDataMapEntityListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerForDataMapAction;
import org.apache.cayenne.modeler.editor.AbstractCallbackListenersTab;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayListener;
import org.apache.cayenne.modeler.util.CayenneAction;

public class DataMapCallbackListenersTab
extends AbstractCallbackListenersTab {
    public DataMapCallbackListenersTab(ProjectController mediator) {
        super(mediator);
    }

    protected CallbackMap getCallbackMap() {
        String listenerClass = (String)this.listenerClassCombo.getSelectedItem();
        return listenerClass == null ? null : this.mediator.getCurrentDataMap().getDefaultEntityListener(listenerClass).getCallbackMap();
    }

    protected List getEntityListeners() {
        return this.mediator.getCurrentDataMap().getDefaultEntityListeners();
    }

    protected void initController() {
        super.initController();
        this.mediator.addDataMapDisplayListener(new DataMapDisplayListener(){

            public void currentDataMapChanged(DataMapDisplayEvent e) {
                if (DataMapCallbackListenersTab.this.isVisible()) {
                    DataMapCallbackListenersTab.this.rebuildListenerClassCombo(null);
                    DataMapCallbackListenersTab.this.updateCallbackTypeCounters();
                    DataMapCallbackListenersTab.this.mediator.setCurrentCallbackType((CallbackType)DataMapCallbackListenersTab.this.callbackTypeCombo.getSelectedItem());
                    DataMapCallbackListenersTab.this.rebuildTable();
                }
            }
        });
    }

    protected CayenneAction getCreateCallbackMethodAction() {
        Application app = Application.getInstance();
        return app.getAction("Create callback method for data map entity listener");
    }

    protected AbstractRemoveCallbackMethodAction getRemoveCallbackMethodAction() {
        Application app = Application.getInstance();
        return (AbstractRemoveCallbackMethodAction)app.getAction("Remove callback method for data map entity listener");
    }

    protected CayenneAction getRemoveEntityListenerAction() {
        return Application.getInstance().getAction(RemoveEntityListenerForDataMapAction.getActionName());
    }

    public CayenneAction getCreateEntityListenerAction() {
        return Application.getInstance().getAction(CreateDataMapEntityListenerAction.getActionName());
    }

    protected EntityListener getEntityListener(String listenerClass) {
        return this.mediator.getCurrentDataMap().getDefaultEntityListener(listenerClass);
    }
}

