/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.EntityTreeFilter;
import org.apache.cayenne.util.XMLSerializable;

public class EntityTreeModel
implements TreeModel {
    protected Entity root;
    protected Map<Object, Object[]> sortedChildren;
    protected EntityTreeFilter filter;

    public EntityTreeModel(Entity root) {
        this.root = root;
        this.sortedChildren = Collections.synchronizedMap(new HashMap());
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object node, int index) {
        return this.sortedChildren(node)[index];
    }

    public int getChildCount(Object node) {
        return node instanceof Attribute ? 0 : this.sortedChildren(node).length;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    public int getIndexOfChild(Object node, Object child) {
        if (node instanceof Attribute) {
            return -1;
        }
        return Arrays.binarySearch(this.sortedChildren(node), child, Comparators.getNamedObjectComparator());
    }

    public void addTreeModelListener(TreeModelListener listener) {
    }

    public void removeTreeModelListener(TreeModelListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] sortedChildren(Object node) {
        Entity entity = this.entityForNonLeafNode(node);
        if (entity == null) {
            return new Object[0];
        }
        Map<Object, Object[]> map = this.sortedChildren;
        synchronized (map) {
            Object key = node;
            Object[] sortedForNode = this.sortedChildren.get(key);
            if (sortedForNode == null) {
                Collection<? extends Attribute> attributes = entity.getAttributes();
                Collection<? extends Relationship> relationships = entity.getRelationships();
                Vector<XMLSerializable> nodes = new Vector<XMLSerializable>();
                for (Attribute attribute : attributes) {
                    if (this.filter != null && !this.filter.attributeMatch(node, attribute)) continue;
                    nodes.add(attribute);
                }
                for (Relationship relationship : relationships) {
                    if (this.filter != null && !this.filter.relationshipMatch(node, relationship)) continue;
                    nodes.add(relationship);
                }
                sortedForNode = nodes.toArray();
                Arrays.sort(sortedForNode, Comparators.getEntityChildrenComparator());
                this.sortedChildren.put(key, sortedForNode);
            }
            return sortedForNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Map<Object, Object[]> map = this.sortedChildren;
        synchronized (map) {
            this.sortedChildren.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateChildren(Entity entity) {
        Map<Object, Object[]> map = this.sortedChildren;
        synchronized (map) {
            this.sortedChildren.remove(entity);
            for (Relationship relationship : entity.getRelationships()) {
                this.sortedChildren.remove(relationship);
            }
        }
    }

    private Entity entityForNonLeafNode(Object node) {
        if (node instanceof Entity) {
            return (Entity)node;
        }
        if (node instanceof Relationship) {
            return ((Relationship)node).getTargetEntity();
        }
        String className = node != null ? node.getClass().getName() : "null";
        throw new IllegalArgumentException("Unexpected non-leaf node: " + className);
    }

    public void setFilter(EntityTreeFilter filter) {
        this.filter = filter;
    }

    public EntityTreeFilter getFilter() {
        return this.filter;
    }
}

