/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.pojo;

import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.ToManyMapProperty;
import org.apache.cayenne.reflect.pojo.EnhancedPojoToManyProperty;
import org.apache.cayenne.util.PersistentObjectMap;

class EnhancedPojoMapProperty
extends EnhancedPojoToManyProperty
implements ToManyMapProperty {
    private Accessor mapKeyAccessor;

    EnhancedPojoMapProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, Accessor accessor, String reverseName, Accessor mapKeyAccessor) {
        super(owner, targetDescriptor, accessor, reverseName);
        this.mapKeyAccessor = mapKeyAccessor;
    }

    protected ValueHolder createValueHolder(Persistent relationshipOwner) {
        return new PersistentObjectMap(relationshipOwner, this.getName(), this.mapKeyAccessor);
    }

    public void addTarget(Object source, Object target, boolean setReverse) {
        if (target == null) {
            throw new NullPointerException("Attempt to add null object.");
        }
        Map collection = (Map)this.readProperty(source);
        collection.put(this.getMapKey(target), target);
        if (setReverse) {
            this.setReverse(source, null, target);
        }
    }

    public void removeTarget(Object source, Object target, boolean setReverse) {
        Map collection = (Map)this.readProperty(source);
        collection.remove(this.getMapKey(target));
        if (target != null && setReverse) {
            this.setReverse(source, target, null);
        }
    }

    public Object getMapKey(Object target) throws PropertyException {
        return this.mapKeyAccessor.getValue(target);
    }
}

