/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.MappingNamesHelper;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.util.Util;

public class DbAttributeValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        DbAttribute attribute = (DbAttribute)path.getObject();
        if (Util.isEmptyString(attribute.getName())) {
            validator.registerError("Unnamed DbAttribute.", path);
        } else {
            MappingNamesHelper helper = MappingNamesHelper.getInstance();
            String invalidChars = helper.invalidCharsInDbPathComponent(attribute.getName());
            if (invalidChars != null) {
                validator.registerWarning("DbAttribute name contains invalid characters: " + invalidChars, path);
            }
        }
        if (attribute.getType() == Integer.MAX_VALUE) {
            validator.registerWarning("DbAttribute has no type.", path);
        } else if (attribute.getMaxLength() < 0 && (attribute.getType() == 12 || attribute.getType() == 1)) {
            validator.registerWarning("Character DbAttribute doesn't have max length.", path);
        }
    }
}

