/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.wocompat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.wocompat.PlistDataStructureFactory;
import org.apache.cayenne.wocompat.parser.Parser;

public class PropertyListSerialization {
    public static Object propertyListFromFile(File f) throws FileNotFoundException {
        return PropertyListSerialization.propertyListFromFile(f, null);
    }

    public static Object propertyListFromFile(File f, PlistDataStructureFactory factory) throws FileNotFoundException {
        if (!f.isFile()) {
            throw new FileNotFoundException("No such file: " + f);
        }
        return new Parser(f, factory).propertyList();
    }

    public static Object propertyListFromStream(InputStream in) {
        return PropertyListSerialization.propertyListFromStream(in, null);
    }

    public static Object propertyListFromStream(InputStream in, PlistDataStructureFactory factory) {
        return new Parser(in, factory).propertyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propertyListToFile(File f, Object plist) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            try {
                PropertyListSerialization.writeObject("", out, plist);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error saving plist.", ioex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propertyListToStream(OutputStream os, Object plist) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));
            try {
                PropertyListSerialization.writeObject("", out, plist);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error saving plist.", ioex);
        }
    }

    protected static void writeObject(String offset, Writer out, Object plist) throws IOException {
        if (plist == null) {
            return;
        }
        if (plist instanceof Collection) {
            Collection list = (Collection)plist;
            out.write(10);
            out.write(offset);
            if (list.size() == 0) {
                out.write("()");
                return;
            }
            out.write("(\n");
            String childOffset = offset + "   ";
            Iterator it = list.iterator();
            boolean appended = false;
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj == null) continue;
                if (appended) {
                    out.write(", \n");
                }
                out.write(childOffset);
                PropertyListSerialization.writeObject(childOffset, out, obj);
                appended = true;
            }
            out.write(10);
            out.write(offset);
            out.write(41);
        } else if (plist instanceof Map) {
            Map map = (Map)plist;
            out.write(10);
            out.write(offset);
            if (map.size() == 0) {
                out.write("{}");
                return;
            }
            out.write("{");
            String childOffset = offset + "    ";
            for (Map.Entry entry : map.entrySet()) {
                Object obj;
                Object key = entry.getKey();
                if (key == null || (obj = entry.getValue()) == null) continue;
                out.write(10);
                out.write(childOffset);
                out.write(PropertyListSerialization.quoteString(key.toString()));
                out.write(" = ");
                PropertyListSerialization.writeObject(childOffset, out, obj);
                out.write(59);
            }
            out.write(10);
            out.write(offset);
            out.write(125);
        } else if (plist instanceof String) {
            out.write(PropertyListSerialization.quoteString(plist.toString()));
        } else if (plist instanceof Number) {
            out.write(plist.toString());
        } else {
            throw new CayenneRuntimeException("Unsupported class for property list serialization: " + plist.getClass().getName());
        }
    }

    protected static String escapeString(String str) {
        char[] chars = str.toCharArray();
        int len = chars.length;
        StringBuilder buf = new StringBuilder(len + 3);
        for (int i = 0; i < len; ++i) {
            if (chars[i] == '\"' || chars[i] == '\\') {
                buf.append('\\');
            }
            buf.append(chars[i]);
        }
        return buf.toString();
    }

    protected static String quoteString(String str) {
        boolean shouldQuote = false;
        String noQuoteExtras = "_$:./";
        char[] chars = str.toCharArray();
        int len = chars.length;
        if (len == 0) {
            shouldQuote = true;
        }
        for (int i = 0; !shouldQuote && i < len; ++i) {
            char c = chars[i];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || noQuoteExtras.indexOf(c) >= 0) continue;
            shouldQuote = true;
        }
        str = PropertyListSerialization.escapeString(str);
        return shouldQuote ? '\"' + str + '\"' : str;
    }
}

