/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils2.BasicDynaClass;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.BenchBean;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaClass;
import org.apache.commons.beanutils2.DynaProperty;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BeanUtilsBenchCase {
    private long counter = 100000L;
    private DynaClass dynaClass;
    private BenchBean inBean;
    private DynaBean inDyna;
    private Map<String, Object> inMap;
    private Map<String, String> inStrs;
    private BenchBean outBean;
    private DynaBean outDyna;
    private BeanUtilsBean bu;

    @BeforeEach
    public void setUp() throws Exception {
        String prop = System.getProperty("counter");
        if (prop != null) {
            this.counter = Long.parseLong(prop);
        }
        this.dynaClass = new BasicDynaClass("BenchDynaClass", null, new DynaProperty[]{new DynaProperty("booleanProperty", Boolean.TYPE), new DynaProperty("byteProperty", Byte.TYPE), new DynaProperty("doubleProperty", Double.TYPE), new DynaProperty("floatProperty", Float.TYPE), new DynaProperty("intProperty", Integer.TYPE), new DynaProperty("longProperty", Long.TYPE), new DynaProperty("shortProperty", Short.TYPE), new DynaProperty("stringProperty", String.class)});
        this.inBean = new BenchBean();
        this.inMap = new HashMap<String, Object>();
        this.inMap.put("booleanProperty", this.inBean.getBooleanProperty());
        this.inMap.put("byteProperty", this.inBean.getByteProperty());
        this.inMap.put("doubleProperty", this.inBean.getDoubleProperty());
        this.inMap.put("floatProperty", Float.valueOf(this.inBean.getFloatProperty()));
        this.inMap.put("intProperty", this.inBean.getIntProperty());
        this.inMap.put("longProperty", this.inBean.getLongProperty());
        this.inMap.put("shortProperty", this.inBean.getShortProperty());
        this.inMap.put("stringProperty", this.inBean.getStringProperty());
        this.inDyna = this.dynaClass.newInstance();
        for (String inKey : this.inMap.keySet()) {
            this.inDyna.set(inKey, this.inMap.get(inKey));
        }
        this.inStrs = new HashMap<String, String>();
        for (String inKey : this.inMap.keySet()) {
            this.inStrs.put(inKey, this.inMap.get(inKey).toString());
        }
        this.outBean = new BenchBean();
        this.outDyna = this.dynaClass.newInstance();
        for (String outKey : this.inMap.keySet()) {
            this.outDyna.set(outKey, this.inMap.get(outKey));
        }
        this.bu = BeanUtilsBean.getInstance();
    }

    @AfterEach
    public void tearDown() {
        this.dynaClass = null;
        this.inBean = null;
        this.inDyna = null;
        this.inMap = null;
        this.outBean = null;
        this.outDyna = null;
        this.bu = null;
    }

    @Test
    public void testCopyPropertiesBean() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, (Object)this.inBean);
        }
        long startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, (Object)this.inBean);
        }
        long stopMillis = System.currentTimeMillis();
        System.err.println("BU.copyProperties(bean,bean), count=" + this.counter + ", time=" + (stopMillis - startMillis));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, (Object)this.inBean);
        }
        startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, (Object)this.inBean);
        }
        stopMillis = System.currentTimeMillis();
        System.err.println("BU.copyProperties(dyna,bean), count=" + this.counter + ", time=" + (stopMillis - startMillis));
    }

    @Test
    public void testCopyPropertiesDyna() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, (Object)this.inDyna);
        }
        long startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, (Object)this.inDyna);
        }
        long stopMillis = System.currentTimeMillis();
        System.err.println("BU.copyProperties(bean,dyna), count=" + this.counter + ", time=" + (stopMillis - startMillis));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, (Object)this.inDyna);
        }
        startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, (Object)this.inDyna);
        }
        stopMillis = System.currentTimeMillis();
        System.err.println("BU.copyProperties(dyna,dyna), count=" + this.counter + ", time=" + (stopMillis - startMillis));
    }

    @Test
    public void testCopyPropertiesMap() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, this.inMap);
        }
        long startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, this.inMap);
        }
        long stopMillis = System.currentTimeMillis();
        System.err.println("BU.copyProperties(bean, map), count=" + this.counter + ", time=" + (stopMillis - startMillis));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, this.inMap);
        }
        startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, this.inMap);
        }
        stopMillis = System.currentTimeMillis();
        System.err.println("BU.copyProperties(dyna, map), count=" + this.counter + ", time=" + (stopMillis - startMillis));
    }

    @Test
    public void testCopyPropertiesStrs() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, this.inStrs);
        }
        long startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outBean, this.inStrs);
        }
        long stopMillis = System.currentTimeMillis();
        System.err.println("BU.copyProperties(bean,strs), count=" + this.counter + ", time=" + (stopMillis - startMillis));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, this.inStrs);
        }
        startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.copyProperties((Object)this.outDyna, this.inStrs);
        }
        stopMillis = System.currentTimeMillis();
        System.err.println("BU.copyProperties(dyna,strs), count=" + this.counter + ", time=" + (stopMillis - startMillis));
    }

    @Test
    public void testPopulateMap() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outBean, this.inMap);
        }
        long startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outBean, this.inMap);
        }
        long stop = System.currentTimeMillis();
        System.err.println("BU.populate(bean, map), count=" + this.counter + ", time=" + (stop - startMillis));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outDyna, this.inMap);
        }
        startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outDyna, this.inMap);
        }
        stop = System.currentTimeMillis();
        System.err.println("BU.populate(dyna, map), count=" + this.counter + ", time=" + (stop - startMillis));
    }

    @Test
    public void testPopulateStrs() throws Exception {
        long i;
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outBean, this.inStrs);
        }
        long startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outBean, this.inStrs);
        }
        long stop = System.currentTimeMillis();
        System.err.println("BU.populate(bean,strs), count=" + this.counter + ", time=" + (stop - startMillis));
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outDyna, this.inStrs);
        }
        startMillis = System.currentTimeMillis();
        for (i = 0L; i < this.counter; ++i) {
            this.bu.populate((Object)this.outDyna, this.inStrs);
        }
        stop = System.currentTimeMillis();
        System.err.println("BU.populate(dyna,strs), count=" + this.counter + ", time=" + (stop - startMillis));
    }
}

