/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.File;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.configuration2.io.DefaultFileSystem;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDefaultFileSystem {
    private DefaultFileSystem fileSystem;

    @BeforeEach
    public void setUp() throws Exception {
        this.fileSystem = new DefaultFileSystem();
    }

    @Test
    void testDefaultLogger() {
        Assertions.assertNotNull((Object)this.fileSystem.getLogger());
    }

    @Test
    void testGetOutputStreamInvalidPath() {
        File file = FileUtils.current();
        Assertions.assertThrows(ConfigurationException.class, () -> this.fileSystem.getOutputStream(file));
    }

    @Test
    void testSetLogger() {
        ConfigurationLogger log = new ConfigurationLogger(this.getClass());
        this.fileSystem.setLogger(log);
        Assertions.assertSame((Object)log, (Object)this.fileSystem.getLogger());
    }
}

