/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.internal;

import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.Region;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.partitioning.EmbeddingHyperplane;

public final class HyperplaneSubsets {
    private HyperplaneSubsets() {
    }

    public static <P extends Point<P>, S extends Point<S>, H extends EmbeddingHyperplane<P, S>, R extends Region<S>> RegionLocation classifyAgainstEmbeddedRegion(P pt, H hyperplane, R embeddedRegion) {
        if (hyperplane.contains(pt)) {
            Object subPoint = hyperplane.toSubspace(pt);
            return embeddedRegion.classify(subPoint);
        }
        return RegionLocation.OUTSIDE;
    }

    public static <P extends Point<P>, S extends Point<S>, H extends EmbeddingHyperplane<P, S>, R extends Region<S>> P closestToEmbeddedRegion(P pt, H hyperplane, R embeddedRegion) {
        Object subPt = hyperplane.toSubspace(pt);
        if (embeddedRegion.contains(subPt)) {
            return hyperplane.toSpace(subPt);
        }
        S subProjected = embeddedRegion.project(subPt);
        if (subProjected != null) {
            return hyperplane.toSpace(subProjected);
        }
        return null;
    }
}

