/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.sofm;

import org.apache.commons.math3.util.FastMath;

class City {
    final String name;
    final double x;
    final double y;

    public City(String name, double x, double y) {
        this.name = name;
        this.x = x;
        this.y = y;
    }

    public String getName() {
        return this.name;
    }

    public double[] getCoordinates() {
        return new double[]{this.x, this.y};
    }

    public double distance(double x, double y) {
        double xDiff = this.x - x;
        double yDiff = this.y - y;
        return FastMath.sqrt((double)(xDiff * xDiff + yDiff * yDiff));
    }

    public boolean equals(Object o) {
        if (o instanceof City) {
            City other = (City)o;
            return this.x == other.x && this.y == other.y;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        long c1 = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(c1 ^ c1 >>> 32);
        long c2 = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(c2 ^ c2 >>> 32);
        return result;
    }
}

