/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.IntegerDistributionAbstractTest;
import org.apache.commons.math3.distribution.PascalDistribution;
import org.junit.Assert;
import org.junit.Test;

public class PascalDistributionTest
extends IntegerDistributionAbstractTest {
    protected double defaultTolerance = 1.0E-9;

    public void setUp() {
        super.setUp();
        this.setTolerance(this.defaultTolerance);
    }

    public IntegerDistribution makeDistribution() {
        return new PascalDistribution(10, 0.7);
    }

    public int[] makeDensityTestPoints() {
        return new int[]{-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0, 0.0282475249, 0.0847425747, 0.139825248255, 0.167790297906, 0.163595540458, 0.137420253985, 0.103065190489, 0.070673273478, 0.0450542118422, 0.0270325271053, 0.01540854045, 0.0084046584273};
    }

    public int[] makeCumulativeTestPoints() {
        return this.makeDensityTestPoints();
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.0, 0.0282475249, 0.1129900996, 0.252815347855, 0.420605645761, 0.584201186219, 0.721621440204, 0.824686630693, 0.895359904171, 0.940414116013, 0.967446643119, 0.982855183569, 0.991259841996};
    }

    public double[] makeInverseCumulativeTestPoints() {
        return new double[]{0.0, 0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9, 1.0};
    }

    public int[] makeInverseCumulativeTestValues() {
        return new int[]{0, 0, 0, 0, 1, 1, 14, 11, 10, 9, 8, Integer.MAX_VALUE};
    }

    @Test
    public void testDegenerate0() {
        this.setDistribution((IntegerDistribution)new PascalDistribution(5, 0.0));
        this.setCumulativeTestPoints(new int[]{-1, 0, 1, 5, 10});
        this.setCumulativeTestValues(new double[]{0.0, 0.0, 0.0, 0.0, 0.0});
        this.setDensityTestPoints(new int[]{-1, 0, 1, 10, 11});
        this.setDensityTestValues(new double[]{0.0, 0.0, 0.0, 0.0, 0.0});
        this.setInverseCumulativeTestPoints(new double[]{0.1, 0.5});
        this.setInverseCumulativeTestValues(new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE});
        this.verifyDensities();
        this.verifyCumulativeProbabilities();
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testDegenerate1() {
        this.setDistribution((IntegerDistribution)new PascalDistribution(5, 1.0));
        this.setCumulativeTestPoints(new int[]{-1, 0, 1, 2, 5, 10});
        this.setCumulativeTestValues(new double[]{0.0, 1.0, 1.0, 1.0, 1.0, 1.0});
        this.setDensityTestPoints(new int[]{-1, 0, 1, 2, 5, 10});
        this.setDensityTestValues(new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 0.0});
        this.setInverseCumulativeTestPoints(new double[]{0.1, 0.5});
        this.setInverseCumulativeTestValues(new int[]{0, 0});
        this.verifyDensities();
        this.verifyCumulativeProbabilities();
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        PascalDistribution dist = new PascalDistribution(10, 0.5);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)10.0, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)20.0, (double)1.0E-9);
        dist = new PascalDistribution(25, 0.7);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)10.714285714285715, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)15.306122448979593, (double)1.0E-9);
    }
}

