/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim.nonlinear.scalar.noderiv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.IntSupplier;
import java.util.function.UnaryOperator;
import org.apache.commons.math4.legacy.analysis.MultivariateFunction;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.MathInternalError;
import org.apache.commons.math4.legacy.exception.MathUnsupportedOperationException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.optim.ConvergenceChecker;
import org.apache.commons.math4.legacy.optim.InitialGuess;
import org.apache.commons.math4.legacy.optim.MaxEval;
import org.apache.commons.math4.legacy.optim.OptimizationData;
import org.apache.commons.math4.legacy.optim.PointValuePair;
import org.apache.commons.math4.legacy.optim.SimpleValueChecker;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.MultivariateOptimizer;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.PopulationSize;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.SimulatedAnnealing;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.noderiv.MultiDirectionalTransform;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.noderiv.Simplex;

public class SimplexOptimizer
extends MultivariateOptimizer {
    private static final double SIMPLEX_SIDE_RATIO = 0.1;
    private Simplex.TransformFactory updateRule;
    private Simplex initialSimplex;
    private SimulatedAnnealing simulatedAnnealing = null;
    private int populationSize = 0;
    private int additionalSearch = 0;
    private final List<Observer> callbacks = new CopyOnWriteArrayList<Observer>();

    public SimplexOptimizer(ConvergenceChecker<PointValuePair> checker) {
        super(checker);
    }

    public SimplexOptimizer(double rel, double abs) {
        this(new SimpleValueChecker(rel, abs));
    }

    public void addObserver(Observer cb) {
        Objects.requireNonNull(cb, "Callback");
        this.callbacks.add(cb);
    }

    @Override
    protected PointValuePair doOptimize() {
        this.checkParameters();
        MultivariateFunction evalFunc = this::computeObjectiveValue;
        boolean isMinim = this.getGoalType() == GoalType.MINIMIZE;
        Comparator comparator = (o1, o2) -> {
            double v1 = (Double)o1.getValue();
            double v2 = (Double)o2.getValue();
            return isMinim ? Double.compare(v1, v2) : Double.compare(v2, v1);
        };
        ArrayList<PointValuePair> bestList = new ArrayList<PointValuePair>();
        Simplex currentSimplex = this.initialSimplex.translate(this.getStartPoint()).evaluate(evalFunc, comparator);
        this.notifyObservers(currentSimplex, true);
        double temperature = Double.NaN;
        Simplex previousSimplex = null;
        if (this.simulatedAnnealing != null) {
            temperature = this.temperature(currentSimplex.get(0), currentSimplex.get(currentSimplex.getDimension()), this.simulatedAnnealing.getStartProbability());
        }
        while (true) {
            if (previousSimplex != null && this.hasConverged(previousSimplex, currentSimplex)) {
                return currentSimplex.get(0);
            }
            previousSimplex = currentSimplex;
            if (this.simulatedAnnealing != null) {
                double endTemperature;
                temperature = (Double)this.simulatedAnnealing.getCoolingSchedule().apply(temperature, currentSimplex);
                if (temperature < (endTemperature = this.temperature(currentSimplex.get(0), currentSimplex.get(currentSimplex.getDimension()), this.simulatedAnnealing.getEndProbability()))) break;
                UnaryOperator<Simplex> update = this.updateRule.create(evalFunc, comparator, this.simulatedAnnealing.metropolis(temperature));
                for (int i = 0; i < this.simulatedAnnealing.getEpochDuration(); ++i) {
                    currentSimplex = this.applyUpdate(update, currentSimplex, evalFunc, comparator);
                }
            } else {
                UnaryOperator<Simplex> update = this.updateRule.create(evalFunc, comparator, null);
                currentSimplex = this.applyUpdate(update, currentSimplex, evalFunc, comparator);
            }
            if (this.additionalSearch != 0) {
                int max = Math.max(this.additionalSearch, 2);
                for (int i = 0; i < currentSimplex.getSize(); ++i) {
                    SimplexOptimizer.keepIfBetter(currentSimplex.get(i), comparator, bestList, max);
                }
            }
            this.incrementIterationCount();
        }
        if (this.additionalSearch > 0) {
            IntSupplier evalCount = () -> this.getEvaluations();
            return this.bestListSearch(evalFunc, comparator, bestList, evalCount);
        }
        throw new MathInternalError();
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        for (OptimizationData data : optData) {
            if (data instanceof Simplex) {
                this.initialSimplex = (Simplex)data;
                continue;
            }
            if (data instanceof Simplex.TransformFactory) {
                this.updateRule = (Simplex.TransformFactory)data;
                continue;
            }
            if (data instanceof SimulatedAnnealing) {
                this.simulatedAnnealing = (SimulatedAnnealing)data;
                continue;
            }
            if (!(data instanceof PopulationSize)) continue;
            this.populationSize = ((PopulationSize)data).getPopulationSize();
        }
    }

    private boolean hasConverged(Simplex previous, Simplex current) {
        ConvergenceChecker<PointValuePair> checker = this.getConvergenceChecker();
        for (int i = 0; i < current.getSize(); ++i) {
            PointValuePair prev = previous.get(i);
            PointValuePair curr = current.get(i);
            if (checker.converged(this.getIterations(), prev, curr)) continue;
            return false;
        }
        return true;
    }

    private void checkParameters() {
        Objects.requireNonNull(this.updateRule, "Update rule");
        Objects.requireNonNull(this.initialSimplex, "Initial simplex");
        if (this.getLowerBound() != null || this.getUpperBound() != null) {
            throw new MathUnsupportedOperationException((Localizable)LocalizedFormats.CONSTRAINT, new Object[0]);
        }
        if (this.populationSize < 0) {
            throw new IllegalArgumentException("Population size");
        }
        this.additionalSearch = this.simulatedAnnealing == null ? Math.max(0, this.populationSize) : Math.max(1, this.populationSize);
    }

    private double temperature(PointValuePair p1, PointValuePair p2, double prob) {
        return -Math.abs((Double)p1.getValue() - (Double)p2.getValue()) / Math.log(prob);
    }

    private static void keepIfBetter(PointValuePair candidate, Comparator<PointValuePair> comp, List<PointValuePair> list, int max) {
        int listSize = list.size();
        double[] candidatePoint = candidate.getPoint();
        if (listSize == 0) {
            list.add(candidate);
        } else if (listSize < max) {
            for (PointValuePair p : list) {
                double[] pPoint = p.getPoint();
                if (!Arrays.equals(pPoint, candidatePoint)) continue;
                return;
            }
            list.add(candidate);
            if (list.size() == max) {
                Collections.sort(list, comp);
            }
        } else {
            int last = max - 1;
            if (comp.compare(candidate, list.get(last)) < 0) {
                for (PointValuePair p : list) {
                    double[] pPoint = p.getPoint();
                    if (!Arrays.equals(pPoint, candidatePoint)) continue;
                    return;
                }
                list.set(last, candidate);
                Collections.sort(list, comp);
            }
        }
    }

    private static double shortestDistance(PointValuePair point, List<PointValuePair> list) {
        double minDist = Double.POSITIVE_INFINITY;
        double[] p = point.getPoint();
        for (PointValuePair other : list) {
            double dist;
            double[] pOther = other.getPoint();
            if (Arrays.equals(p, pOther) || !((dist = MathArrays.distance((double[])p, (double[])pOther)) < minDist)) continue;
            minDist = dist;
        }
        return minDist;
    }

    private PointValuePair bestListSearch(MultivariateFunction evalFunc, Comparator<PointValuePair> comp, List<PointValuePair> bestList, IntSupplier evalCount) {
        PointValuePair best = bestList.get(0);
        for (int i = 0; i < this.additionalSearch; ++i) {
            Simplex simplex;
            PointValuePair start = bestList.get(i);
            double dist = SimplexOptimizer.shortestDistance(start, bestList);
            double[] init = start.getPoint();
            PointValuePair r = SimplexOptimizer.directSearch(init, simplex = Simplex.equalSidesAlongAxes(init.length, 0.1 * dist), evalFunc, this.getConvergenceChecker(), this.getGoalType(), this.callbacks, evalCount);
            if (comp.compare(r, best) >= 0) continue;
            best = r;
        }
        return best;
    }

    private static PointValuePair directSearch(double[] init, Simplex simplex, MultivariateFunction eval, ConvergenceChecker<PointValuePair> checker, GoalType goalType, List<Observer> cbList, IntSupplier evalCount) {
        SimplexOptimizer optim = new SimplexOptimizer(checker);
        for (Observer cOrig : cbList) {
            Observer cNew = (spx, isInit, numEval) -> cOrig.update(spx, isInit, evalCount.getAsInt());
            optim.addObserver(cNew);
        }
        return optim.optimize(MaxEval.unlimited(), new ObjectiveFunction(eval), goalType, new InitialGuess(init), simplex, new MultiDirectionalTransform());
    }

    private void notifyObservers(Simplex simplex, boolean isInit) {
        for (Observer cb : this.callbacks) {
            cb.update(simplex, isInit, this.getEvaluations());
        }
    }

    private Simplex applyUpdate(UnaryOperator<Simplex> update, Simplex simplex, MultivariateFunction eval, Comparator<PointValuePair> comp) {
        Simplex transformed = ((Simplex)update.apply(simplex)).evaluate(eval, comp);
        this.notifyObservers(transformed, false);
        return transformed;
    }

    @FunctionalInterface
    public static interface Observer {
        public void update(Simplex var1, boolean var2, int var3);
    }
}

