/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.field.linalg;

import org.apache.commons.math4.legacy.field.linalg.FieldDecompositionSolver;
import org.apache.commons.math4.legacy.field.linalg.FieldDenseMatrix;
import org.apache.commons.math4.legacy.linear.SingularMatrixException;
import org.apache.commons.numbers.field.Field;

public final class FieldLUDecomposition<T> {
    private final Field<T> field;
    private final FieldDenseMatrix<T> mLU;
    private final int[] pivot;
    private final boolean isSingular;
    private final boolean isEven;

    private FieldLUDecomposition(FieldDenseMatrix<T> matrix) {
        matrix.checkMultiply(matrix);
        this.field = matrix.getField();
        int m = matrix.getRowDimension();
        this.pivot = new int[m];
        for (int row = 0; row < m; ++row) {
            this.pivot[row] = row;
        }
        this.mLU = matrix.copy();
        boolean even = true;
        boolean singular = false;
        for (int col = 0; col < m; ++col) {
            int i;
            Object sum = this.field.zero();
            for (int row = 0; row < col; ++row) {
                sum = this.mLU.get(row, col);
                for (int i2 = 0; i2 < row; ++i2) {
                    sum = this.field.subtract(sum, this.field.multiply(this.mLU.get(row, i2), this.mLU.get(i2, col)));
                }
                this.mLU.set(row, col, sum);
            }
            int nonZero = col;
            for (int row = col; row < m; ++row) {
                sum = this.mLU.get(row, col);
                for (i = 0; i < col; ++i) {
                    sum = this.field.subtract(sum, this.field.multiply(this.mLU.get(row, i), this.mLU.get(i, col)));
                }
                this.mLU.set(row, col, sum);
                if (!this.mLU.get(nonZero, col).equals(this.field.zero())) continue;
                ++nonZero;
            }
            if (nonZero >= m) {
                singular = true;
                continue;
            }
            if (nonZero != col) {
                Object tmp = this.field.zero();
                for (i = 0; i < m; ++i) {
                    tmp = this.mLU.get(nonZero, i);
                    this.mLU.set(nonZero, i, this.mLU.get(col, i));
                    this.mLU.set(col, i, tmp);
                }
                int temp = this.pivot[nonZero];
                this.pivot[nonZero] = this.pivot[col];
                this.pivot[col] = temp;
                even = !even;
            }
            T luDiag = this.mLU.get(col, col);
            for (int row = col + 1; row < m; ++row) {
                this.mLU.set(row, col, this.field.divide(this.mLU.get(row, col), luDiag));
            }
        }
        this.isSingular = singular;
        this.isEven = even;
    }

    public static <T> FieldLUDecomposition<T> of(FieldDenseMatrix<T> m) {
        return new FieldLUDecomposition<T>(m);
    }

    public boolean isSingular() {
        return this.isSingular;
    }

    public FieldDenseMatrix<T> getL() {
        if (this.isSingular) {
            throw new SingularMatrixException();
        }
        int m = this.pivot.length;
        FieldDenseMatrix<Object> mL = FieldDenseMatrix.zero(this.field, m, m);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < i; ++j) {
                mL.set(i, j, this.mLU.get(i, j));
            }
            mL.set(i, i, this.field.one());
        }
        return mL;
    }

    public FieldDenseMatrix<T> getU() {
        if (this.isSingular) {
            throw new SingularMatrixException();
        }
        int m = this.pivot.length;
        FieldDenseMatrix<T> mU = FieldDenseMatrix.zero(this.field, m, m);
        for (int i = 0; i < m; ++i) {
            for (int j = i; j < m; ++j) {
                mU.set(i, j, this.mLU.get(i, j));
            }
        }
        return mU;
    }

    public FieldDenseMatrix<T> getP() {
        if (this.isSingular) {
            throw new SingularMatrixException();
        }
        int m = this.pivot.length;
        FieldDenseMatrix<Object> mP = FieldDenseMatrix.zero(this.field, m, m);
        for (int i = 0; i < m; ++i) {
            mP.set(i, this.pivot[i], this.field.one());
        }
        return mP;
    }

    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    public T getDeterminant() {
        if (this.isSingular) {
            return (T)this.field.zero();
        }
        int m = this.pivot.length;
        Object determinant = this.isEven ? this.field.one() : this.field.negate(this.field.one());
        for (int i = 0; i < m; ++i) {
            determinant = this.field.multiply(determinant, this.mLU.get(i, i));
        }
        return (T)determinant;
    }

    public FieldDecompositionSolver<T> getSolver() {
        if (this.isSingular) {
            throw new SingularMatrixException();
        }
        return new Solver(this.mLU, this.pivot);
    }

    private static final class Solver<T>
    implements FieldDecompositionSolver<T> {
        private final Field<T> field;
        private final FieldDenseMatrix<T> mLU;
        private final int[] pivot;

        private Solver(FieldDenseMatrix<T> mLU, int[] pivot) {
            this.field = mLU.getField();
            this.mLU = mLU.copy();
            this.pivot = (int[])pivot.clone();
        }

        @Override
        public FieldDenseMatrix<T> solve(FieldDenseMatrix<T> b) {
            int j;
            int i;
            int col;
            this.mLU.checkMultiply(b);
            FieldDenseMatrix<Object> bp = b.copy();
            int nColB = b.getColumnDimension();
            int m = this.pivot.length;
            for (int row = 0; row < m; ++row) {
                int pRow = this.pivot[row];
                for (int col2 = 0; col2 < nColB; ++col2) {
                    bp.set(row, col2, b.get(row, col2));
                }
            }
            for (col = 0; col < m; ++col) {
                for (i = col + 1; i < m; ++i) {
                    for (j = 0; j < nColB; ++j) {
                        bp.set(i, j, this.field.subtract(bp.get(i, j), this.field.multiply(bp.get(col, j), this.mLU.get(i, col))));
                    }
                }
            }
            for (col = m - 1; col >= 0; --col) {
                for (int j2 = 0; j2 < nColB; ++j2) {
                    bp.set(col, j2, this.field.divide(bp.get(col, j2), this.mLU.get(col, col)));
                }
                for (i = 0; i < col; ++i) {
                    for (j = 0; j < nColB; ++j) {
                        bp.set(i, j, this.field.subtract(bp.get(i, j), this.field.multiply(bp.get(col, j), this.mLU.get(i, col))));
                    }
                }
            }
            return bp;
        }

        @Override
        public FieldDenseMatrix<T> getInverse() {
            return this.solve(FieldDenseMatrix.identity(this.field, this.pivot.length));
        }
    }
}

