/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ajp;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.ajp.AbstractAjpClientStreamSourceChannel;
import io.undertow.protocols.ajp.AjpClientChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.util.HeaderMap;
import java.io.IOException;
import java.nio.channels.Channel;
import org.xnio.ChannelListener;

public class AjpClientResponseStreamSourceChannel
extends AbstractAjpClientStreamSourceChannel {
    private ChannelListener<AjpClientResponseStreamSourceChannel> finishListener;
    private final HeaderMap headers;
    private final int statusCode;
    private final String reasonPhrase;

    public AjpClientResponseStreamSourceChannel(AjpClientChannel framedChannel, HeaderMap headers, int statusCode, String reasonPhrase, PooledByteBuffer frameData, int remaining) {
        super(framedChannel, frameData, (long)remaining);
        this.headers = headers;
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public void setFinishListener(ChannelListener<AjpClientResponseStreamSourceChannel> finishListener) {
        this.finishListener = finishListener;
    }

    @Override
    protected void handleHeaderData(FrameHeaderData headerData) {
        if (headerData instanceof AjpClientChannel.EndResponse) {
            this.lastFrame();
        }
    }

    @Override
    protected long updateFrameDataRemaining(PooledByteBuffer frameData, long frameDataRemaining) {
        if (frameDataRemaining > 0L && (long)frameData.getBuffer().remaining() == frameDataRemaining) {
            frameData.getBuffer().limit(frameData.getBuffer().limit() - 1);
            return frameDataRemaining - 1L;
        }
        return frameDataRemaining;
    }

    @Override
    protected void complete() throws IOException {
        if (this.finishListener != null) {
            ((AjpClientChannel)this.getFramedChannel()).sourceDone();
            this.finishListener.handleEvent((Channel)((Object)this));
        }
    }

    @Override
    public void wakeupReads() {
        super.wakeupReads();
        ((AjpClientChannel)this.getFramedChannel()).resumeReceives();
    }

    @Override
    public void resumeReads() {
        super.resumeReads();
        ((AjpClientChannel)this.getFramedChannel()).resumeReceives();
    }

    @Override
    public void suspendReads() {
        ((AjpClientChannel)this.getFramedChannel()).suspendReceives();
        super.suspendReads();
    }
}

