/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ext.ParamConverter;
import org.apache.cxf.jaxrs.utils.HttpUtils;

public class UrlEncodingParamConverter
implements ParamConverter<String> {
    private Set<Character> encodeClientParametersList;

    public UrlEncodingParamConverter() {
        this(null);
    }

    public UrlEncodingParamConverter(String encodeClientParametersListStr) {
        if (encodeClientParametersListStr != null) {
            String[] chars = encodeClientParametersListStr.trim().split(" ");
            this.encodeClientParametersList = new HashSet<Character>();
            for (String ch : chars) {
                this.encodeClientParametersList.add(Character.valueOf(ch.charAt(0)));
            }
        }
    }

    public String fromString(String s) {
        return HttpUtils.urlDecode((String)s);
    }

    public String toString(String s) {
        if (this.encodeClientParametersList == null || this.encodeClientParametersList.isEmpty()) {
            return HttpUtils.urlEncode((String)s);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            Character ch = Character.valueOf(s.charAt(i));
            if (this.encodeClientParametersList.contains(ch)) {
                sb.append(HttpUtils.urlEncode((String)ch.toString()));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

