/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import io.undertow.util.Certificates;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import javax.net.ssl.SSLPeerUnverifiedException;

public class SslClientCertAttribute
implements ExchangeAttribute {
    public static final SslClientCertAttribute INSTANCE = new SslClientCertAttribute();

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        SSLSessionInfo ssl = exchange.getConnection().getSslSessionInfo();
        if (ssl == null) {
            return null;
        }
        try {
            Certificate[] certificates = ssl.getPeerCertificates();
            if (certificates.length > 0) {
                return Certificates.toPem(certificates[0]);
            }
            return null;
        }
        catch (RenegotiationRequiredException | CertificateEncodingException | SSLPeerUnverifiedException e) {
            return null;
        }
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("SSL Client Cert", newValue);
    }

    public String toString() {
        return "%{SSL_CLIENT_CERT}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "SSL Client Cert";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals("%{SSL_CLIENT_CERT}")) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

