/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.component;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.DestroyedComponentException;
import net.shibboleth.shared.component.IdentifiedComponent;
import net.shibboleth.shared.component.UninitializedComponentException;
import net.shibboleth.shared.component.UnmodifiableComponentException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

@ThreadSafe
public abstract class AbstractIdentifiedInitializableComponent
extends AbstractInitializableComponent
implements IdentifiedComponent {
    @NonnullAfterInit
    @GuardedBy(value="this")
    private String id;

    @Override
    @NonnullAfterInit
    @NotEmpty
    public synchronized String getId() {
        return this.id;
    }

    @Nonnull
    public final String ensureId() {
        String idCopy = this.getId();
        if (idCopy == null) {
            throw new IllegalStateException();
        }
        return idCopy;
    }

    @Override
    protected final void ifDestroyedThrowDestroyedComponentException() {
        if (this.isDestroyed()) {
            throw new DestroyedComponentException("Component '" + StringSupport.trimOrNull(this.getId()) + "' has already been destroyed and can no longer be used.");
        }
    }

    @Override
    protected final void ifNotInitializedThrowUninitializedComponentException() {
        if (!this.isInitialized()) {
            throw new UninitializedComponentException("Component '" + StringSupport.trimOrNull(this.getId()) + "' has not yet been initialized and cannot be used.");
        }
    }

    @Override
    protected final void ifInitializedThrowUnmodifiabledComponentException() {
        if (this.isInitialized()) {
            throw new UnmodifiableComponentException("Component '" + StringSupport.trimOrNull(this.getId()) + "' has already been initialized and can no longer be modified");
        }
    }

    protected synchronized void setId(@Nonnull @NotEmpty String componentId) {
        this.checkSetterPreconditions();
        this.id = Constraint.isNotNull(StringSupport.trimOrNull(componentId), "Component ID cannot be null or empty");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getId() == null) {
            throw new ComponentInitializationException("Component ID for type " + this.getClass() + " cannot be null");
        }
    }
}

