/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.encoded;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.encoded.SoapRef;

public class SoapRefRegistry {
    private final SortedMap<String, Object> instances = new TreeMap<String, Object>();
    private final SortedMap<String, List<SoapRef>> unresolvedRefs = new TreeMap<String, List<SoapRef>>();

    public static SoapRefRegistry get(Context context) {
        SoapRefRegistry soapRefRegistry = context.getProperty(SoapRefRegistry.class);
        if (soapRefRegistry == null) {
            soapRefRegistry = new SoapRefRegistry();
            context.setProperty(soapRefRegistry);
        }
        return soapRefRegistry;
    }

    public void addInstance(String id, Object instance) {
        Object oldInstance = this.instances.put(id, instance);
        if (oldInstance != null) {
            throw new DatabindingException("Id " + id + " is already registered to instance " + String.valueOf(instance));
        }
        List list = (List)this.unresolvedRefs.remove(id);
        if (list != null) {
            for (SoapRef soapRef : list) {
                soapRef.set(instance);
            }
        }
    }

    public void addRef(String id, SoapRef soapRef) {
        Object value = this.instances.get(id);
        if (value != null) {
            soapRef.set(value);
        } else {
            ArrayList<SoapRef> list = (ArrayList<SoapRef>)this.unresolvedRefs.get(id);
            if (list == null) {
                list = new ArrayList<SoapRef>();
                this.unresolvedRefs.put(id, list);
            }
            list.add(soapRef);
        }
    }

    public Set<String> getIds() {
        return Collections.unmodifiableSet(this.instances.keySet());
    }

    public SortedMap<String, List<SoapRef>> getUnresolvedRefs() {
        return this.unresolvedRefs;
    }
}

