/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.daffodil.api.DataLocation;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.api.infoset.InfosetDocument;
import org.apache.daffodil.api.infoset.InfosetOutputter;
import org.apache.daffodil.io.DataInputStream;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.lib.exceptions.Abort;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.iapi.DaffodilTunables;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.lib.util.MStackOf;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.lib.util.Pool;
import org.apache.daffodil.lib.util.Poolable;
import org.apache.daffodil.lib.util.ThreadSafePool;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.apache.daffodil.runtime1.infoset.DIComplex;
import org.apache.daffodil.runtime1.infoset.DIComplexState;
import org.apache.daffodil.runtime1.infoset.DIComplexState$;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DISimpleState;
import org.apache.daffodil.runtime1.infoset.DISimpleState$;
import org.apache.daffodil.runtime1.infoset.InfosetWalker;
import org.apache.daffodil.runtime1.processors.CheckBitOrderAndCharsetEv;
import org.apache.daffodil.runtime1.processors.CheckByteAndBitOrderEv;
import org.apache.daffodil.runtime1.processors.DataLoc;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.NonTermRuntimeData;
import org.apache.daffodil.runtime1.processors.ParseOrUnparseState;
import org.apache.daffodil.runtime1.processors.ProcessorResult;
import org.apache.daffodil.runtime1.processors.RuntimeData;
import org.apache.daffodil.runtime1.processors.Suspension;
import org.apache.daffodil.runtime1.processors.TermRuntimeData;
import org.apache.daffodil.runtime1.processors.VariableInstance;
import org.apache.daffodil.runtime1.processors.VariableMap;
import org.apache.daffodil.runtime1.processors.VariableRuntimeData;
import org.apache.daffodil.runtime1.processors.parsers.MPState;
import org.apache.daffodil.runtime1.processors.parsers.PState$;
import org.apache.daffodil.runtime1.processors.parsers.PStateUsingMacrosMixin;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

public final class PState
extends ParseOrUnparseState
implements PStateUsingMacrosMixin {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PState.class.getDeclaredField("regexMatchStatePool$lzy1"));
    private DIElement infoset;
    private Object infosetLastChild;
    private InputSourceDataInputStream dataInputStream;
    private final InfosetWalker walker;
    private final MPState mpstate;
    private final DataProcessor dataProcArg;
    private Object delimitedParseResult;
    private Seq blobPaths;
    private final MStackOf pointsOfUncertainty;
    private final MarkPool markPool;
    private volatile Object regexMatchStatePool$lzy1;

    public static PState createInitialPState(ElementRuntimeData elementRuntimeData, InputSourceDataInputStream inputSourceDataInputStream, InfosetOutputter infosetOutputter, DFDL.DataProcessor dataProcessor, boolean bl) {
        return PState$.MODULE$.createInitialPState(elementRuntimeData, inputSourceDataInputStream, infosetOutputter, dataProcessor, bl);
    }

    public static PState createInitialPState(ElementRuntimeData elementRuntimeData, ReadableByteChannel readableByteChannel, InfosetOutputter infosetOutputter, DFDL.DataProcessor dataProcessor, boolean bl) {
        return PState$.MODULE$.createInitialPState(elementRuntimeData, readableByteChannel, infosetOutputter, dataProcessor, bl);
    }

    public static PState createInitialPState(ElementRuntimeData elementRuntimeData, String string, InfosetOutputter infosetOutputter, DFDL.DataProcessor dataProcessor, boolean bl) {
        return PState$.MODULE$.createInitialPState(elementRuntimeData, string, infosetOutputter, dataProcessor, bl);
    }

    public static PState createInitialPState(InfosetDocument infosetDocument, ElementRuntimeData elementRuntimeData, InputSourceDataInputStream inputSourceDataInputStream, InfosetOutputter infosetOutputter, DFDL.DataProcessor dataProcessor, boolean bl) {
        return PState$.MODULE$.createInitialPState(infosetDocument, elementRuntimeData, inputSourceDataInputStream, infosetOutputter, dataProcessor, bl);
    }

    public PState(DIElement infoset, Object infosetLastChild, InputSourceDataInputStream dataInputStream, InfosetWalker walker, VariableMap vmap, Seq<Diagnostic> diagnosticsArg, MPState mpstate, DataProcessor dataProcArg, Object delimitedParseResult, Seq<Path> blobPaths, DaffodilTunables tunable) {
        this.infoset = infoset;
        this.infosetLastChild = infosetLastChild;
        this.dataInputStream = dataInputStream;
        this.walker = walker;
        this.mpstate = mpstate;
        this.dataProcArg = dataProcArg;
        this.delimitedParseResult = delimitedParseResult;
        this.blobPaths = blobPaths;
        super(vmap, diagnosticsArg, Maybe$One$.MODULE$.apply(dataProcArg), tunable);
        this.pointsOfUncertainty = new MStackOf();
        this.markPool = new MarkPool();
    }

    @Override
    public DIElement infoset() {
        return this.infoset;
    }

    public void infoset_$eq(DIElement x$1) {
        this.infoset = x$1;
    }

    public Object infosetLastChild() {
        return this.infosetLastChild;
    }

    public void infosetLastChild_$eq(Object x$1) {
        this.infosetLastChild = x$1;
    }

    public InputSourceDataInputStream dataInputStream() {
        return this.dataInputStream;
    }

    public void dataInputStream_$eq(InputSourceDataInputStream x$1) {
        this.dataInputStream = x$1;
    }

    public InfosetWalker walker() {
        return this.walker;
    }

    public MPState mpstate() {
        return this.mpstate;
    }

    @Override
    public Object delimitedParseResult() {
        return this.delimitedParseResult;
    }

    public void delimitedParseResult_$eq(Object x$1) {
        this.delimitedParseResult = x$1;
    }

    public Seq<Path> blobPaths() {
        return this.blobPaths;
    }

    public void blobPaths_$eq(Seq<Path> x$1) {
        this.blobPaths = x$1;
    }

    @Override
    public Object currentNode() {
        return Maybe$.MODULE$.apply(this.infoset());
    }

    public InfosetOutputter output() {
        return this.walker().outputter();
    }

    public MStackOf<Mark> pointsOfUncertainty() {
        return this.pointsOfUncertainty;
    }

    @Override
    public Object dataStream() {
        return Maybe$One$.MODULE$.apply(this.dataInputStream());
    }

    public void saveDelimitedParseResult(Object result) {
        this.delimitedParseResult_$eq(result);
    }

    public void clearDelimitedParseResult() {
        this.delimitedParseResult_$eq(Maybe$.MODULE$.Nope());
    }

    @Override
    public boolean hasInfoset() {
        return true;
    }

    @Override
    public DIElement thisElement() {
        return this.infoset();
    }

    @Override
    public long groupPos() {
        return this.mpstate().groupPos();
    }

    @Override
    public long arrayIterationPos() {
        return this.mpstate().arrayIterationPos();
    }

    @Override
    public long occursPos() {
        return this.mpstate().occursPos();
    }

    @Override
    public long childPos() {
        return this.mpstate().childPos();
    }

    private Mark mark(String requestorID, RuntimeData context) {
        Mark m = (Mark)this.markPool.getFromPool(requestorID);
        m.captureFrom(this, requestorID, context);
        DIElement dIElement = m.element();
        dIElement.infosetWalkerBlockCount_$eq(dIElement.infosetWalkerBlockCount() + 1);
        return m;
    }

    public boolean isInUse(Mark m) {
        return this.markPool.isInUse(m);
    }

    public boolean dataInputStreamIsValid() {
        return this.dataInputStream().inputSource().isValid();
    }

    private void reset(Mark m) {
        DIElement dIElement = m.element();
        dIElement.infosetWalkerBlockCount_$eq(dIElement.infosetWalkerBlockCount() - 1);
        m.restoreInto(this);
        m.clear();
        this.markPool.returnToPool(m);
    }

    private void discard(Mark m) {
        DIElement dIElement = m.element();
        dIElement.infosetWalkerBlockCount_$eq(dIElement.infosetWalkerBlockCount() - 1);
        this.dataInputStream().discard(m.disMark());
        m.clear();
        this.markPool.returnToPool(m);
    }

    public String toString() {
        String hidden = this.withinHiddenNest() ? "hidden " : "";
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("PState( bitPos=%s status=%s %s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.bitPos0b()), this.processorStatus(), hidden}));
    }

    @Override
    public DataLocation currentLocation() {
        return new DataLoc(this.bitPos1b(), this.bitLimit1b(), (Either<DataOutputStream, DataInputStream>)package$.MODULE$.Right().apply((Object)this.dataInputStream()), Maybe$.MODULE$.apply(this.thisElement().runtimeData()));
    }

    @Override
    public long bitPos0b() {
        return this.dataInputStream().bitPos0b();
    }

    @Override
    public long bitLimit0b() {
        return this.dataInputStream().bitLimit0b();
    }

    public DISimple simpleElement() {
        DIElement dIElement = this.infoset();
        if (!(dIElement instanceof DISimple)) {
            throw Assert$.MODULE$.usageError("not a simple element");
        }
        DISimple s = (DISimple)dIElement;
        DISimple res = s;
        return res;
    }

    public DIComplex complexElement() {
        DIElement dIElement = this.infoset();
        if (!(dIElement instanceof DIComplex)) {
            throw Assert$.MODULE$.usageError("not a complex element.");
        }
        DIComplex c = (DIComplex)dIElement;
        DIComplex res = c;
        return res;
    }

    public InfosetDocument parentDocument() {
        return (InfosetDocument)((Object)this.infoset());
    }

    public void setEndBitLimit(long bitLimit0b) {
        this.dataInputStream().setBitLimit0b(MaybeULong$.MODULE$.apply(bitLimit0b));
    }

    public void setInfoset(DIElement newInfoset, Object newInfosetLastChild) {
        this.infoset_$eq(newInfoset);
        this.infosetLastChild_$eq(newInfosetLastChild);
    }

    private void changingVariable() {
        if (!this.pointsOfUncertainty().isEmpty()) {
            Mark curPoU = this.pointsOfUncertainty().top();
            if (curPoU.variableMap() == this.variableMap()) {
                this.setVariableMap(this.variableMap().copy());
                return;
            }
            return;
        }
    }

    @Override
    public void setVariable(VariableRuntimeData vrd, Object newValue, ThrowsSDE referringContext) {
        this.changingVariable();
        this.variableMap().setVariable(vrd, newValue, referringContext, this);
    }

    @Override
    public Object getVariable(VariableRuntimeData vrd, ThrowsSDE referringContext) {
        if (this.variableMap().readVariableWillChangeState(vrd)) {
            this.changingVariable();
        }
        return this.variableMap().readVariable(vrd, referringContext, this);
    }

    @Override
    public VariableInstance newVariableInstance(VariableRuntimeData vrd) {
        this.changingVariable();
        return this.variableMap().newVariableInstance(vrd);
    }

    @Override
    public void removeVariableInstance(VariableRuntimeData vrd) {
        this.variableMap().removeVariableInstance(vrd);
    }

    public Mark createPointOfUncertainty(String pouID, RuntimeData context) {
        Mark pou = this.mark(pouID, context);
        this.pointsOfUncertainty().push(pou);
        return pou;
    }

    public void resetToPointOfUncertainty(Mark pou) {
        if (this.isPointOfUncertaintyResolved(pou)) {
            throw Assert$.MODULE$.usageError("PState.this.isPointOfUncertaintyResolved(pou).unary_!");
        }
        Mark pouPop = this.pointsOfUncertainty().pop();
        Mark mark = pou;
        Mark mark2 = pouPop;
        if (mark == null ? mark2 != null : !mark.equals(mark2)) {
            throw Assert$.MODULE$.abort("Invariant broken: pou.==(pouPop)");
        }
        this.reset(pouPop);
    }

    public void discardPointOfUncertainty(Mark pou) {
        if (this.isPointOfUncertaintyResolved(pou)) {
            throw Assert$.MODULE$.usageError("PState.this.isPointOfUncertaintyResolved(pou).unary_!");
        }
        Mark pouPop = this.pointsOfUncertainty().pop();
        Mark mark = pou;
        Mark mark2 = pouPop;
        if (mark == null ? mark2 != null : !mark.equals(mark2)) {
            throw Assert$.MODULE$.abort("Invariant broken: pou.==(pouPop)");
        }
        this.discard(pou);
    }

    public void resolvePointOfUncertainty() {
        if (!this.pointsOfUncertainty().isEmpty()) {
            Mark pouPop = this.pointsOfUncertainty().pop();
            this.discard(pouPop);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPointOfUncertaintyResolved(Mark pou) {
        if (this.pointsOfUncertainty().isEmpty()) return true;
        Mark mark = this.pointsOfUncertainty().top();
        Mark mark2 = pou;
        if (mark == null) {
            if (mark2 == null) return false;
            return true;
        } else if (mark.equals(mark2)) return false;
        return true;
    }

    public void addBlobPath(Path path) {
        this.blobPaths_$eq((Seq<Path>)((Seq)this.blobPaths().$plus$colon((Object)path)));
    }

    @Override
    public final void notifyDebugging(boolean flag) {
        this.dataInputStream().setDebugging(flag);
    }

    @Override
    public final void checkBitOrder() {
        InputSourceDataInputStream dis = this.dataInputStream();
        boolean isChanging = this.isParseBitOrderChanging(dis);
        if (isChanging) {
            RuntimeData runtimeData = this.processor().context();
            if (runtimeData instanceof TermRuntimeData) {
                TermRuntimeData trd = (TermRuntimeData)runtimeData;
                Object mcboc = trd.maybeCheckBitOrderAndCharsetEv();
                Object mcbbo = trd.maybeCheckByteAndBitOrderEv();
                if (Maybe$.MODULE$.isDefined$extension(mcboc)) {
                    ((CheckBitOrderAndCharsetEv)Maybe$.MODULE$.get$extension(mcboc)).evaluate(this);
                }
                if (Maybe$.MODULE$.isDefined$extension(mcbbo)) {
                    ((CheckByteAndBitOrderEv)Maybe$.MODULE$.get$extension(mcbbo)).evaluate(this);
                }
            }
            dis.cst().setPriorBitOrder(this.bitOrder());
            if (!dis.isAligned(8)) {
                throw this.SDE("Can only change dfdl:bitOrder on a byte boundary. Bit pos (1b) was %s.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)dis.bitPos1b())}));
            }
            return;
        }
    }

    private boolean isParseBitOrderChanging(InputSourceDataInputStream dis) {
        BitOrder newBitOrder;
        RuntimeData runtimeData = this.processor().context();
        if (runtimeData instanceof NonTermRuntimeData) {
            NonTermRuntimeData ntrd = (NonTermRuntimeData)runtimeData;
            return false;
        }
        BitOrder priorBitOrder = dis.cst().priorBitOrder();
        return priorBitOrder != (newBitOrder = this.bitOrder());
    }

    @Override
    public ThreadSafePool<Tuple2<CharBuffer, LongBuffer>> regexMatchStatePool() {
        Object object = this.regexMatchStatePool$lzy1;
        if (object instanceof ThreadSafePool) {
            return (ThreadSafePool)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ThreadSafePool)this.regexMatchStatePool$lzyINIT1();
    }

    private Object regexMatchStatePool$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.regexMatchStatePool$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ThreadSafePool<Tuple2<CharBuffer, LongBuffer>> threadSafePool = null;
                    try {
                        threadSafePool = this.dataProcArg.regexMatchStatePool();
                        object2 = threadSafePool == null ? LazyVals.NullValue$.MODULE$ : threadSafePool;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.regexMatchStatePool$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return threadSafePool;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyFinalState(Object optThrown) {
        try {
            if (Maybe$.MODULE$.isEmpty$extension(optThrown)) {
                if (this.pointsOfUncertainty().length() != 0) {
                    throw Assert$.MODULE$.abort("Invariant broken: this.pointsOfUncertainty.length.==(0)");
                }
                if (this.withinHiddenNest()) {
                    throw Assert$.MODULE$.abort("Invariant broken: this.withinHiddenNest.unary_!");
                }
                this.mpstate().verifyFinalState();
            }
            this.markPool.finalCheck();
            this.dataInputStream().inputSource().compact();
            this.dataInputStream().validateFinalStreamState();
            return;
        }
        catch (Throwable e) {
            if (Maybe$.MODULE$.isDefined$extension(optThrown)) {
                e.addSuppressed((Throwable)Maybe$.MODULE$.get$extension(optThrown));
            }
            Abort toThrow = new Abort(e);
            toThrow.addSuppressed(e);
            throw toThrow;
        }
    }

    public ProcessorResult withTempSuccess(Function1<PState, BoxedUnit> func) {
        ProcessorResult priorProcessorStatus = this.processorStatus();
        this.setSuccess();
        func.apply((Object)this);
        ProcessorResult funcStatus = this.processorStatus();
        this._processorStatus_$eq(priorProcessorStatus);
        return funcStatus;
    }

    @Override
    public Seq<Suspension> suspensions() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static class Mark
    implements Poolable {
        private String org$apache$daffodil$lib$util$Poolable$$poolDebugLabel_;
        private final DISimpleState simpleElementState;
        private final DIComplexState complexElementState;
        private DIElement element;
        private Object elementLastChild;
        private DataInputStream.Mark disMark;
        private VariableMap variableMap;
        private ProcessorResult processorStatus;
        private boolean validationStatus;
        private Seq diagnostics;
        private Object delimitedParseResult;
        private Seq blobPaths;
        private RuntimeData context;
        private final MPState.Mark mpStateMark;

        public Mark() {
            Poolable.$init$(this);
            this.simpleElementState = DISimpleState$.MODULE$.apply();
            this.complexElementState = DIComplexState$.MODULE$.apply();
            this.delimitedParseResult = Maybe$.MODULE$.Nope();
            this.blobPaths = (Seq)package$.MODULE$.Seq().empty();
            this.mpStateMark = new MPState.Mark();
        }

        @Override
        public String org$apache$daffodil$lib$util$Poolable$$poolDebugLabel_() {
            return this.org$apache$daffodil$lib$util$Poolable$$poolDebugLabel_;
        }

        @Override
        public void org$apache$daffodil$lib$util$Poolable$$poolDebugLabel__$eq(String x$1) {
            this.org$apache$daffodil$lib$util$Poolable$$poolDebugLabel_ = x$1;
        }

        public String toString() {
            if (this.disMark() != null) {
                return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("bitPos: %s, context: %s [%s] (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.bitPos0b()).toString(), this.context().toString(), this.context().locationDescription(), this.poolDebugLabel()}));
            }
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("bitPos: (uninitialized), context: %s [%s] (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.context().toString(), this.context().locationDescription(), this.poolDebugLabel()}));
        }

        public long bitPos0b() {
            return this.disMark().bitPos0b();
        }

        public DISimpleState simpleElementState() {
            return this.simpleElementState;
        }

        public DIComplexState complexElementState() {
            return this.complexElementState;
        }

        public DIElement element() {
            return this.element;
        }

        public void element_$eq(DIElement x$1) {
            this.element = x$1;
        }

        public Object elementLastChild() {
            return this.elementLastChild;
        }

        public void elementLastChild_$eq(Object x$1) {
            this.elementLastChild = x$1;
        }

        public DataInputStream.Mark disMark() {
            return this.disMark;
        }

        public void disMark_$eq(DataInputStream.Mark x$1) {
            this.disMark = x$1;
        }

        public VariableMap variableMap() {
            return this.variableMap;
        }

        public void variableMap_$eq(VariableMap x$1) {
            this.variableMap = x$1;
        }

        public ProcessorResult processorStatus() {
            return this.processorStatus;
        }

        public void processorStatus_$eq(ProcessorResult x$1) {
            this.processorStatus = x$1;
        }

        public boolean validationStatus() {
            return this.validationStatus;
        }

        public void validationStatus_$eq(boolean x$1) {
            this.validationStatus = x$1;
        }

        public Seq<Diagnostic> diagnostics() {
            return this.diagnostics;
        }

        public void diagnostics_$eq(Seq<Diagnostic> x$1) {
            this.diagnostics = x$1;
        }

        public Object delimitedParseResult() {
            return this.delimitedParseResult;
        }

        public void delimitedParseResult_$eq(Object x$1) {
            this.delimitedParseResult = x$1;
        }

        public Seq<Path> blobPaths() {
            return this.blobPaths;
        }

        public void blobPaths_$eq(Seq<Path> x$1) {
            this.blobPaths = x$1;
        }

        public RuntimeData context() {
            return this.context;
        }

        public void context_$eq(RuntimeData x$1) {
            this.context = x$1;
        }

        public MPState.Mark mpStateMark() {
            return this.mpStateMark;
        }

        public void clear() {
            this.elementLastChild_$eq(Maybe$.MODULE$.Nope());
            this.simpleElementState().clear();
            this.complexElementState().clear();
            this.disMark_$eq(null);
            this.variableMap_$eq(null);
            this.processorStatus_$eq(null);
            this.validationStatus_$eq(true);
            this.diagnostics_$eq(null);
            this.delimitedParseResult_$eq(Maybe$.MODULE$.Nope());
            this.mpStateMark().clear();
            this.blobPaths_$eq((Seq<Path>)((Seq)package$.MODULE$.Seq().empty()));
        }

        public void captureFrom(PState ps, String requestorID, RuntimeData context) {
            this.element_$eq(ps.thisElement());
            this.elementLastChild_$eq(ps.infosetLastChild());
            if (this.element().isSimple()) {
                this.simpleElementState().captureFrom(this.element());
            } else {
                this.complexElementState().captureFrom(this.element());
            }
            this.disMark_$eq(ps.dataInputStream().mark(requestorID));
            this.processorStatus_$eq(ps.processorStatus());
            this.validationStatus_$eq(ps.validationStatus());
            this.diagnostics_$eq(ps.diagnostics());
            this.mpStateMark().captureFrom(ps.mpstate());
            this.blobPaths_$eq(ps.blobPaths());
            this.context_$eq(context);
            this.variableMap_$eq(ps.variableMap());
        }

        public void restoreInfoset(PState ps) {
            if (this.element() != ps.thisElement()) {
                throw Assert$.MODULE$.abort("Invariant broken: this.element.eq(ps.thisElement)");
            }
            DIElement dIElement = this.element();
            if (dIElement instanceof DISimple) {
                DISimple s = (DISimple)dIElement;
                this.simpleElementState().restoreInto(this.element());
                return;
            }
            if (dIElement instanceof DIComplex) {
                DIComplex c = (DIComplex)dIElement;
                this.complexElementState().restoreInto(this.element());
                return;
            }
            throw new MatchError((Object)dIElement);
        }

        public void restoreInto(PState ps) {
            this.restoreInfoset(ps);
            ps.infosetLastChild_$eq(this.elementLastChild());
            ps.dataInputStream().reset(this.disMark());
            ps.setVariableMap(this.variableMap());
            ps._processorStatus_$eq(this.processorStatus());
            ps._validationStatus_$eq(this.validationStatus());
            ps.diagnostics_$eq(this.diagnostics());
            ps.delimitedParseResult_$eq(this.delimitedParseResult());
            this.mpStateMark().restoreInto(ps.mpstate());
            Seq<Path> blobsToKeep = this.blobPaths();
            for (Seq currentBlobs = ps.blobPaths(); currentBlobs != blobsToKeep; currentBlobs = (Seq)currentBlobs.tail()) {
                Files.delete((Path)currentBlobs.head());
            }
            ps.blobPaths_$eq(blobsToKeep);
        }
    }

    public static class MarkPool
    implements Pool<Mark> {
        private MStackOf org$apache$daffodil$lib$util$Pool$$pool;
        private HashSet org$apache$daffodil$lib$util$Pool$$inUse;
        private int org$apache$daffodil$lib$util$Pool$$numOutstanding;

        public MarkPool() {
            Pool.$init$(this);
            Statics.releaseFence();
        }

        @Override
        public MStackOf org$apache$daffodil$lib$util$Pool$$pool() {
            return this.org$apache$daffodil$lib$util$Pool$$pool;
        }

        @Override
        public HashSet org$apache$daffodil$lib$util$Pool$$inUse() {
            return this.org$apache$daffodil$lib$util$Pool$$inUse;
        }

        @Override
        public int org$apache$daffodil$lib$util$Pool$$numOutstanding() {
            return this.org$apache$daffodil$lib$util$Pool$$numOutstanding;
        }

        @Override
        public void org$apache$daffodil$lib$util$Pool$$numOutstanding_$eq(int x$1) {
            this.org$apache$daffodil$lib$util$Pool$$numOutstanding = x$1;
        }

        @Override
        public void org$apache$daffodil$lib$util$Pool$_setter_$org$apache$daffodil$lib$util$Pool$$pool_$eq(MStackOf x$0) {
            this.org$apache$daffodil$lib$util$Pool$$pool = x$0;
        }

        @Override
        public void org$apache$daffodil$lib$util$Pool$_setter_$org$apache$daffodil$lib$util$Pool$$inUse_$eq(HashSet x$0) {
            this.org$apache$daffodil$lib$util$Pool$$inUse = x$0;
        }

        @Override
        public Mark allocate() {
            return new Mark();
        }
    }
}

