/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaAnotB;
import org.apache.datasketches.theta.ThetaAnotBimpl;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AnotBimplTest {
    @Test
    public void checkExactAnotB_AvalidNoOverlap() {
        int i;
        int k = 512;
        UpdatableThetaSketch usk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        ThetaAnotB aNb = ThetaSetOperation.builder().buildANotB();
        Assert.assertTrue((boolean)aNb.isEmpty());
        Assert.assertTrue((aNb.getCache().length == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)aNb.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((short)aNb.getSeedHash(), (short)Util.computeSeedHash((long)9001L));
        aNb.setA((ThetaSketch)usk1);
        aNb.notB((ThetaSketch)usk2);
        Assert.assertEquals((int)aNb.getRetainedEntries(), (int)256);
        CompactThetaSketch rsk1 = aNb.getResult(false, null, true);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)256.0);
        aNb.setA((ThetaSketch)usk1);
        aNb.notB((ThetaSketch)usk2);
        rsk1 = aNb.getResult(true, null, true);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)256.0);
        int bytes = rsk1.getCurrentBytes();
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        aNb.setA((ThetaSketch)usk1);
        aNb.notB((ThetaSketch)usk2);
        rsk1 = aNb.getResult(false, wseg, true);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)256.0);
        aNb.setA((ThetaSketch)usk1);
        aNb.notB((ThetaSketch)usk2);
        rsk1 = aNb.getResult(true, wseg, true);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)256.0);
    }

    @Test
    public void checkCombinations() {
        int k = 512;
        ThetaSketch aNull = null;
        ThetaSketch bNull = null;
        UpdatableThetaSketch aEmpty = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        UpdatableThetaSketch bEmpty = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        UpdatableThetaSketch aHT = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 512; ++i) {
            aHT.update((long)i);
        }
        CompactThetaSketch aC = aHT.compact(false, null);
        CompactThetaSketch aO = aHT.compact(true, null);
        UpdatableThetaSketch bHT = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        for (int i = 256; i < 768; ++i) {
            bHT.update((long)i);
        }
        CompactThetaSketch bC = bHT.compact(false, null);
        CompactThetaSketch bO = bHT.compact(true, null);
        boolean ordered = true;
        ThetaAnotB aNb = ThetaSetOperation.builder().buildANotB();
        try {
            aNb.setA(aNull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        aNb.notB(bNull);
        try {
            aNb.aNotB(aNull, bNull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            aNb.aNotB(aNull, (ThetaSketch)bEmpty);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            aNb.aNotB((ThetaSketch)aEmpty, bNull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        CompactThetaSketch result = aNb.aNotB((ThetaSketch)aEmpty, (ThetaSketch)bEmpty, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aEmpty, (ThetaSketch)bC, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aEmpty, (ThetaSketch)bO, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aEmpty, (ThetaSketch)bHT, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aC, (ThetaSketch)bEmpty, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)512.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aC, (ThetaSketch)bC, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aC, (ThetaSketch)bO, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aC, (ThetaSketch)bHT, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aO, (ThetaSketch)bEmpty, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)512.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aO, (ThetaSketch)bC, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aO, (ThetaSketch)bO, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aO, (ThetaSketch)bHT, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aHT, (ThetaSketch)bEmpty, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)512.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aHT, (ThetaSketch)bC, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aHT, (ThetaSketch)bO, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
        result = aNb.aNotB((ThetaSketch)aHT, (ThetaSketch)bHT, false, null);
        Assert.assertEquals((double)result.getEstimate(), (double)256.0);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getThetaLong(), (long)Long.MAX_VALUE);
    }

    @Test
    public void checkAnotBnotC() {
        int k = 1024;
        boolean ordered = true;
        UpdatableThetaSketch aU = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        for (int i = 0; i < 1024; ++i) {
            aU.update((long)i);
        }
        UpdatableThetaSketch bU = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        for (int i = 0; i < 512; ++i) {
            bU.update((long)i);
        }
        UpdatableThetaSketch cU = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        for (int i = 512; i < 768; ++i) {
            cU.update((long)i);
        }
        int segBytes = ThetaSketch.getMaxUpdateSketchBytes((int)1024);
        MemorySegment wseg1 = MemorySegment.ofArray(new byte[segBytes]);
        MemorySegment wseg2 = MemorySegment.ofArray(new byte[segBytes]);
        MemorySegment wseg3 = MemorySegment.ofArray(new byte[segBytes]);
        ThetaAnotB aNb = ThetaSetOperation.builder().buildANotB();
        aNb.setA((ThetaSketch)aU);
        CompactThetaSketch result1 = aNb.aNotB((ThetaSketch)aU, (ThetaSketch)bU, true, wseg1);
        aNb.notB((ThetaSketch)bU);
        CompactThetaSketch result2 = aNb.aNotB((ThetaSketch)result1, (ThetaSketch)cU, true, wseg2);
        aNb.notB((ThetaSketch)cU);
        double est2 = result2.getEstimate();
        AnotBimplTest.println("est: " + est2);
        Assert.assertEquals((double)est2, (double)256.0, (double)0.0);
        CompactThetaSketch result3 = aNb.getResult(true, wseg3, true);
        double est3 = result3.getEstimate();
        Assert.assertEquals((double)est3, (double)256.0, (double)0.0);
    }

    @Test
    public void checkAnotBnotC_sameMemorySegment() {
        int k = 1024;
        boolean ordered = true;
        UpdatableThetaSketch a = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        for (int i = 0; i < 1024; ++i) {
            a.update((long)i);
        }
        UpdatableThetaSketch b = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        for (int i = 0; i < 512; ++i) {
            b.update((long)i);
        }
        UpdatableThetaSketch c = UpdatableThetaSketch.builder().setNominalEntries(1024).build();
        for (int i = 512; i < 768; ++i) {
            c.update((long)i);
        }
        int segBytes = ThetaSketch.getMaxCompactSketchBytes((int)a.getRetainedEntries(true));
        MemorySegment seg = MemorySegment.ofArray(new byte[segBytes]);
        ThetaAnotB aNb = ThetaSetOperation.builder().buildANotB();
        aNb.setA((ThetaSketch)a);
        CompactThetaSketch result1 = aNb.aNotB((ThetaSketch)a, (ThetaSketch)b, true, seg);
        aNb.notB((ThetaSketch)b);
        result1 = aNb.aNotB((ThetaSketch)result1, (ThetaSketch)c, true, seg);
        aNb.notB((ThetaSketch)c);
        CompactThetaSketch result2 = aNb.getResult(true, seg, true);
        double est1 = result1.getEstimate();
        AnotBimplTest.println("est: " + est1);
        Assert.assertEquals((double)est1, (double)256.0, (double)0.0);
        double est2 = result2.getEstimate();
        Assert.assertEquals((double)est2, (double)256.0, (double)0.0);
    }

    @Test
    public void checkAnotBsimple() {
        UpdatableThetaSketch skA = UpdatableThetaSketch.builder().build();
        UpdatableThetaSketch skB = UpdatableThetaSketch.builder().build();
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        CompactThetaSketch csk = aNotB.aNotB((ThetaSketch)skA, (ThetaSketch)skB);
        Assert.assertEquals((int)csk.getCurrentBytes(), (int)8);
    }

    @Test
    public void checkGetResult() {
        UpdatableThetaSketch skA = UpdatableThetaSketch.builder().build();
        UpdatableThetaSketch skB = UpdatableThetaSketch.builder().build();
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        CompactThetaSketch csk = aNotB.aNotB((ThetaSketch)skA, (ThetaSketch)skB);
        Assert.assertEquals((int)csk.getCurrentBytes(), (int)8);
    }

    @Test
    public void checkGetFamily() {
        ThetaAnotBimpl anotb = new ThetaAnotBimpl(9001L);
        Assert.assertEquals((Object)anotb.getFamily(), (Object)Family.A_NOT_B);
    }

    @Test
    public void checkGetMaxBytes() {
        int bytes = ThetaSetOperation.getMaxAnotBResultBytes((int)10);
        Assert.assertEquals((int)bytes, (int)264);
    }

    @Test
    public void printlnTest() {
        AnotBimplTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

