/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.outlet;

import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.SaxHelper;
import org.apache.torque.generator.configuration.outlet.OutletSaxHandler;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.template.velocity.VelocityOutlet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class VelocityOutletSaxHandler
extends OutletSaxHandler {
    public VelocityOutletSaxHandler(QualifiedName outletName, ConfigurationProvider configurationProvider, ProjectPaths projectPaths, ConfigurationHandlers configurationHandlers) throws SAXException {
        super(outletName, configurationProvider, projectPaths, configurationHandlers);
    }

    protected VelocityOutlet createOutlet(QualifiedName outletName, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (outletName == null) {
            String nameAttribute = attributes.getValue("name");
            if (nameAttribute == null) {
                throw new SAXException("The attribute name must be set on the element " + rawName + " for Velocity Outlets");
            }
            outletName = new QualifiedName(nameAttribute);
        }
        String encoding = attributes.getValue("encoding");
        String path = attributes.getValue("path");
        try {
            Boolean variablesInContext;
            Boolean sourceElementAttributesInContext;
            VelocityOutlet result = new VelocityOutlet(outletName, this.getConfigurationProvider(), path, encoding);
            Boolean optionsInContext = SaxHelper.getBooleanAttribute("optionsInContext", attributes, "the velocityOutlet" + outletName);
            if (optionsInContext != null) {
                result.setOptionsInContext(optionsInContext);
            }
            if ((sourceElementAttributesInContext = SaxHelper.getBooleanAttribute("sourceAttributesInContext", attributes, "the velocityOutlet" + outletName)) != null) {
                result.setSourceAttributesInContext(sourceElementAttributesInContext);
            }
            if ((variablesInContext = SaxHelper.getBooleanAttribute("variablesInContext", attributes, "the velocityOutlet" + outletName)) != null) {
                result.setVariablesInContext(variablesInContext);
            }
            return result;
        }
        catch (ConfigurationException e) {
            throw new SAXException(e);
        }
    }
}

