package org.apache.torque.generator.configuration.outlet;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.paths.CustomProjectPaths;
import org.apache.torque.generator.configuration.paths.DefaultTorqueGeneratorPaths;
import org.apache.torque.generator.configuration.paths.Maven2DirectoryProjectPaths;
import org.apache.torque.generator.control.Controller;
import org.junit.Before;
import org.junit.Test;

/**
 * Tests that another template language can easily integrated.
 *
 * @version $Id: OtherTemplateLanguageTest.java 1337543 2012-05-12 13:48:45Z tfischer $
 */
public class OtherTemplateLanguageTest
{
    private static final File TARGET_DIR
            = new File("target/test/otherTemplateLanguages");

    private static final File OUTPUT_FILE
            = new File(TARGET_DIR, "output.txt");

    @Before
    public void setUp() throws Exception
    {
        FileUtils.deleteDirectory(TARGET_DIR);
    }

    /**
     * Tests that Groovy outlets can be used.
     *
     * @throws Exception if an error occurs.
     */
    @Test
    public void testOtherTemplateLanguages() throws Exception
    {
        Controller controller = new Controller();
        List<UnitDescriptor> unitDescriptors = new ArrayList<UnitDescriptor>();
        CustomProjectPaths projectPaths = new CustomProjectPaths(
                new Maven2DirectoryProjectPaths(
                        new File("src/test/otherTemplateLanguages")));
        projectPaths.setOutputDirectory(null, TARGET_DIR);
        unitDescriptors.add(new UnitDescriptor(
                UnitDescriptor.Packaging.DIRECTORY,
                projectPaths,
                new DefaultTorqueGeneratorPaths()));
        controller.run(unitDescriptors);
        // TODO: check outcome against reference file
        assertTrue(OUTPUT_FILE.exists());
        assertEquals(
                "groovy test output",
                FileUtils.readFileToString(OUTPUT_FILE));
    }
}
