/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.server;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;

public class TimeoutConfigurableRMISocketFactory
extends RMISocketFactory
implements Serializable {
    private static final long serialVersionUID = 1489909775271203334L;
    private int readTimeout = 5000;
    private int openTimeout = 5000;

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(this.readTimeout);
        socket.setSoLinger(false, 0);
        socket.connect(new InetSocketAddress(host, port), this.openTimeout);
        return socket;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setOpenTimeout(int openTimeout) {
        this.openTimeout = openTimeout;
    }

    public int getOpenTimeout() {
        return this.openTimeout;
    }
}

