/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Text;
import org.apache.orc.impl.Dictionary;
import org.apache.orc.impl.DictionaryUtils;
import org.apache.orc.impl.DynamicByteArray;
import org.apache.orc.impl.DynamicIntArray;
import org.apache.orc.impl.VisitorContextImpl;

public class StringHashTableDictionary
implements Dictionary {
    private final DynamicByteArray byteArray = new DynamicByteArray();
    private final DynamicIntArray keyOffsets;
    private final Text newKey = new Text();
    private DynamicIntArray[] hashBuckets;
    private int capacity;
    private int threshold;
    private float loadFactor;
    private static float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int BUCKET_SIZE = 8;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public StringHashTableDictionary(int initialCapacity) {
        this(initialCapacity, DEFAULT_LOAD_FACTOR);
    }

    public StringHashTableDictionary(int initialCapacity, float loadFactor) {
        this.capacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.keyOffsets = new DynamicIntArray(initialCapacity);
        this.initializeHashBuckets();
        this.threshold = (int)Math.min((float)initialCapacity * loadFactor, 2.1474836E9f);
    }

    private void initializeHashBuckets() {
        DynamicIntArray[] newBuckets = this.hashBuckets == null ? new DynamicIntArray[this.capacity] : this.hashBuckets;
        for (int i = 0; i < this.capacity; ++i) {
            newBuckets[i] = this.createBucket();
        }
        this.hashBuckets = newBuckets;
    }

    private DynamicIntArray createBucket() {
        return new DynamicIntArray(8);
    }

    @Override
    public void visit(Dictionary.Visitor visitor) throws IOException {
        this.traverse(visitor, new VisitorContextImpl(this.byteArray, this.keyOffsets));
    }

    private void traverse(Dictionary.Visitor visitor, VisitorContextImpl context) throws IOException {
        for (DynamicIntArray intArray : this.hashBuckets) {
            for (int i = 0; i < intArray.size(); ++i) {
                context.setPosition(intArray.get(i));
                visitor.visit(context);
            }
        }
    }

    @Override
    public void clear() {
        this.byteArray.clear();
        this.keyOffsets.clear();
        this.initializeHashBuckets();
    }

    @Override
    public void getText(Text result, int positionInKeyOffset) {
        DictionaryUtils.getTextInternal(result, positionInKeyOffset, this.keyOffsets, this.byteArray);
    }

    @Override
    public int add(byte[] bytes, int offset, int length) {
        this.newKey.set(bytes, offset, length);
        return this.add(this.newKey);
    }

    public int add(Text text) {
        this.resizeIfNeeded();
        this.newKey.set(text);
        int index = this.getIndex(text);
        DynamicIntArray candidateArray = this.hashBuckets[index];
        Text tmpText = new Text();
        for (int i = 0; i < candidateArray.size(); ++i) {
            this.getText(tmpText, candidateArray.get(i));
            if (!tmpText.equals((Object)this.newKey)) continue;
            return candidateArray.get(i);
        }
        int len = this.newKey.getLength();
        int currIdx = this.keyOffsets.size();
        this.keyOffsets.add(this.byteArray.add(this.newKey.getBytes(), 0, len));
        candidateArray.add(currIdx);
        return currIdx;
    }

    private void resizeIfNeeded() {
        if (this.keyOffsets.size() >= this.threshold) {
            int newCapacity;
            int oldCapacity = this.capacity;
            this.capacity = newCapacity = (oldCapacity << 1) + 1;
            this.doResize(newCapacity, oldCapacity);
            this.threshold = (int)Math.min((float)newCapacity * this.loadFactor, 2.1474836E9f);
        }
    }

    @Override
    public int size() {
        return this.keyOffsets.size();
    }

    int getIndex(Text text) {
        return Math.floorMod(text.hashCode(), this.capacity);
    }

    private void doResize(int newCapacity, int oldCapacity) {
        DynamicIntArray[] resizedHashBuckets = new DynamicIntArray[newCapacity];
        for (int i = 0; i < newCapacity; ++i) {
            resizedHashBuckets[i] = this.createBucket();
        }
        Text tmpText = new Text();
        for (int i = 0; i < oldCapacity; ++i) {
            DynamicIntArray oldBucket = this.hashBuckets[i];
            for (int j = 0; j < oldBucket.size(); ++j) {
                this.getText(tmpText, oldBucket.get(j));
                resizedHashBuckets[this.getIndex(tmpText)].add(oldBucket.get(j));
            }
        }
        Arrays.fill(this.hashBuckets, null);
        this.hashBuckets = resizedHashBuckets;
    }

    @Override
    public long getSizeInBytes() {
        long bucketTotalSize = 0L;
        for (DynamicIntArray dynamicIntArray : this.hashBuckets) {
            bucketTotalSize += (long)dynamicIntArray.size();
        }
        return this.byteArray.getSizeInBytes() + (long)this.keyOffsets.getSizeInBytes() + bucketTotalSize;
    }
}

