/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll.vector;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.druid.java.util.common.StringEncoding;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregatorHelper;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildUtil;
import org.apache.druid.query.aggregation.datasketches.hll.vector.HllSketchBuildVectorProcessor;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;

public class MultiValueStringHllSketchBuildVectorProcessor
implements HllSketchBuildVectorProcessor {
    private final HllSketchBuildBufferAggregatorHelper helper;
    private final StringEncoding stringEncoding;
    private final MultiValueDimensionVectorSelector selector;

    public MultiValueStringHllSketchBuildVectorProcessor(HllSketchBuildBufferAggregatorHelper helper, StringEncoding stringEncoding, MultiValueDimensionVectorSelector selector) {
        this.helper = helper;
        this.stringEncoding = stringEncoding;
        this.selector = selector;
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        IndexedInts[] vector = this.selector.getRowVector();
        HllSketch sketch = this.helper.getSketchAtPosition(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            IndexedInts ids = vector[i];
            int sz = ids.size();
            for (int j = 0; j < sz; ++j) {
                HllSketchBuildUtil.updateSketchWithDictionarySelector(sketch, this.stringEncoding, (DimensionDictionarySelector)this.selector, ids.get(j));
            }
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        IndexedInts[] vector = this.selector.getRowVector();
        for (int i = 0; i < numRows; ++i) {
            int idx = rows != null ? rows[i] : i;
            int position = positions[i] + positionOffset;
            HllSketch sketch = this.helper.getSketchAtPosition(buf, position);
            IndexedInts ids = vector[idx];
            int sz = ids.size();
            for (int j = 0; j < sz; ++j) {
                HllSketchBuildUtil.updateSketchWithDictionarySelector(sketch, this.stringEncoding, (DimensionDictionarySelector)this.selector, ids.get(j));
            }
        }
    }
}

