/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.util.ServiceUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class RequestLogTracker
extends ServiceTracker<RequestLog, RequestLog>
implements RequestLog {
    public static final int MAX_ERROR_COUNT = 100;
    private final ConcurrentMap<ServiceReference<?>, RequestLog> logSvcs = new ConcurrentHashMap();
    private final ConcurrentMap<ServiceReference<?>, Integer> naughtyStep = new ConcurrentHashMap();

    RequestLogTracker(BundleContext context, String filter) throws InvalidSyntaxException {
        super(context, RequestLogTracker.buildFilter(filter), null);
    }

    private static Filter buildFilter(String inputFilter) throws InvalidSyntaxException {
        Object compositeFilter;
        String objectClassFilter = String.format("(%s=%s)", "objectClass", RequestLog.class.getName());
        if (inputFilter != null) {
            FrameworkUtil.createFilter((String)inputFilter);
            compositeFilter = "(&" + objectClassFilter + inputFilter + ")";
        } else {
            compositeFilter = objectClassFilter;
        }
        return FrameworkUtil.createFilter((String)compositeFilter);
    }

    public RequestLog addingService(ServiceReference<RequestLog> reference) {
        RequestLog logSvc = ServiceUtils.safeGetService(this.context, reference);
        if (logSvc != null) {
            this.logSvcs.put(reference, logSvc);
        }
        return logSvc;
    }

    public void removedService(ServiceReference<RequestLog> reference, RequestLog logSvc) {
        this.logSvcs.remove(reference);
        this.naughtyStep.remove(reference);
        ServiceUtils.safeUngetService(this.context, reference);
    }

    public void log(Request request, Response response) {
        for (Map.Entry entry : this.logSvcs.entrySet()) {
            try {
                ((RequestLog)entry.getValue()).log(request, response);
            }
            catch (Exception e) {
                this.processError((ServiceReference)entry.getKey(), e);
            }
        }
    }

    private void processError(ServiceReference<?> reference, Exception e) {
        SystemLogger.LOGGER.error(SystemLogger.formatMessage(reference, String.format("Error dispatching to request log service ID %d from bundle %s:%s", reference.getProperty("service.id"), reference.getBundle().getSymbolicName(), reference.getBundle().getVersion())), (Throwable)e);
        int naughty = this.naughtyStep.merge(reference, 1, Integer::sum);
        if (naughty >= 100) {
            this.logSvcs.remove(reference);
            this.naughtyStep.remove(reference);
            SystemLogger.LOGGER.error(SystemLogger.formatMessage(reference, String.format("RequestLog service ID %d from bundle %s:%s threw too many errors, it will no longer be invoked.", reference.getProperty("service.id"), reference.getBundle().getSymbolicName(), reference.getBundle().getVersion())));
        }
    }
}

