/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.samples.filter;

import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.felix.http.api.ExtHttpService;
import org.apache.felix.http.samples.filter.TestFilter;
import org.apache.felix.http.samples.filter.TestServlet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class Activator
implements BundleActivator {
    private ServiceTracker tracker;
    private TestServlet servlet1 = new TestServlet("servlet1");
    private TestServlet servlet2 = new TestServlet("servlet2");
    private TestFilter filter1 = new TestFilter("filter1");
    private TestFilter filter2 = new TestFilter("filter2");

    public void start(BundleContext context) throws Exception {
        this.tracker = new ServiceTracker(context, ExtHttpService.class.getName(), null){

            public Object addingService(ServiceReference ref) {
                Object service = super.addingService(ref);
                Activator.this.serviceAdded((ExtHttpService)service);
                return service;
            }

            public void removedService(ServiceReference ref, Object service) {
                Activator.this.serviceRemoved((ExtHttpService)service);
                super.removedService(ref, service);
            }
        };
        this.tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.tracker.close();
    }

    private void serviceAdded(ExtHttpService service) {
        try {
            service.registerServlet("/", (Servlet)this.servlet1, null, null);
            service.registerServlet("/other", (Servlet)this.servlet2, null, null);
            service.registerFilter((Filter)this.filter1, ".*", null, 0, null);
            service.registerFilter((Filter)this.filter2, "/other/.*", null, 100, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void serviceRemoved(ExtHttpService service) {
        service.unregisterServlet((Servlet)this.servlet1);
        service.unregisterServlet((Servlet)this.servlet2);
        service.unregisterFilter((Filter)this.filter1);
        service.unregisterFilter((Filter)this.filter2);
    }
}

