/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationResult<T> {
    private final Method method;
    private final Object target;
    private final T result;
    private final Throwable error;

    public InvocationResult(Method method, Object target, T result, Throwable error) {
        this.method = method;
        this.target = target;
        this.result = result;
        this.error = error;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getTarget() {
        return this.target;
    }

    public Throwable error() {
        return this.error;
    }

    public T get() {
        return this.result;
    }

    public T getOrElse(T def) {
        if (this.error == null) {
            return def;
        }
        return this.result;
    }

    public static <T> InvocationResult<T> fromInvocation(Method method, Object target, Object[] args) {
        try {
            Object result = method.invoke(target, args);
            return new InvocationResult<Object>(method, target, result, null);
        }
        catch (IllegalAccessException e) {
            return new InvocationResult<Object>(method, target, null, e);
        }
        catch (InvocationTargetException e) {
            return new InvocationResult<Object>(method, target, null, e);
        }
    }
}

