/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.queue;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamingThreadFactory
implements ThreadFactory {
    private static final AtomicInteger IDENTIFIERS = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ThreadFactory m_threadFactory;
    private final int m_identifier;

    public static void reset() {
        IDENTIFIERS.set(1);
    }

    public NamingThreadFactory(ThreadFactory threadFactory) {
        this(threadFactory, IDENTIFIERS.getAndIncrement());
    }

    private NamingThreadFactory(ThreadFactory threadFactory, int identifier) {
        this.m_threadFactory = threadFactory;
        this.m_identifier = identifier;
    }

    public Thread newThread(Runnable r) {
        Thread thread = this.m_threadFactory.newThread(r);
        thread.setName(String.format("pool-%d-thread-%d", this.m_identifier, this.threadNumber.getAndIncrement()));
        return thread;
    }
}

