/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.event.publisher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.handlers.event.publisher.Publisher;
import org.apache.felix.ipojo.handlers.event.publisher.PublisherDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class EventAdminPublisherHandlerDescription
extends HandlerDescription {
    List m_publishersDescriptions = new ArrayList();

    public EventAdminPublisherHandlerDescription(Handler handler, Collection publishers) {
        super(handler);
        if (publishers != null) {
            Iterator iterator = publishers.iterator();
            while (iterator.hasNext()) {
                Publisher p = (Publisher)iterator.next();
                this.m_publishersDescriptions.add(new PublisherDescription(p));
            }
        }
    }

    public PublisherDescription[] getPublisherDescriptions() {
        return this.m_publishersDescriptions.toArray(new PublisherDescription[this.m_publishersDescriptions.size()]);
    }

    public Element getHandlerInfo() {
        Element root = super.getHandlerInfo();
        for (int i = 0; i < this.m_publishersDescriptions.size(); ++i) {
            PublisherDescription p = (PublisherDescription)this.m_publishersDescriptions.get(i);
            Element publisher = new Element("Publisher", "");
            publisher.addAttribute(new Attribute("name", p.getName()));
            publisher.addAttribute(new Attribute("synchronous", String.valueOf(p.isSynchronous())));
            publisher.addAttribute(new Attribute("data_key", p.getDataKey()));
            Element topics = new Element("Topics", "");
            if (p.getTopics() != null) {
                for (int j = 0; j < p.getTopics().length; ++j) {
                    String topic = p.getTopics()[j];
                    Element e_topic = new Element("topic", "");
                    topics.addElement(e_topic);
                    e_topic.addAttribute(new Attribute("name", topic));
                }
            }
            publisher.addElement(topics);
            root.addElement(publisher);
        }
        return root;
    }
}

