/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.filestore;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class ResettableTimer {
    private final ScheduledExecutorService m_executor;
    private final Runnable m_task;
    private final long m_timeout;
    private final TimeUnit m_timeUnit;
    private final AtomicReference m_futureRef;

    public ResettableTimer(Runnable task, long timeout, TimeUnit unit) {
        this(new ScheduledThreadPoolExecutor(1), task, timeout, unit);
    }

    public ResettableTimer(ScheduledExecutorService executor, Runnable task, long timeout, TimeUnit unit) {
        if (executor == null) {
            throw new IllegalArgumentException("Executor cannot be null!");
        }
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null!");
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative!");
        }
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be null!");
        }
        this.m_executor = executor;
        this.m_task = task;
        this.m_timeout = timeout;
        this.m_timeUnit = unit;
        this.m_futureRef = new AtomicReference();
    }

    public boolean isShutDown() {
        return this.m_executor.isShutdown();
    }

    public ScheduledFuture schedule() {
        ScheduledFuture currentTask = this.cancelCurrentTask();
        ScheduledFuture<?> newTask = this.m_executor.schedule(this.m_task, this.m_timeout, this.m_timeUnit);
        this.m_futureRef.compareAndSet(currentTask, newTask);
        return newTask;
    }

    public void shutDown() {
        this.m_executor.shutdown();
        try {
            this.m_executor.awaitTermination(2L * this.m_timeout, this.m_timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private ScheduledFuture cancelCurrentTask() {
        ScheduledFuture currentTask = (ScheduledFuture)this.m_futureRef.get();
        if (currentTask != null) {
            currentTask.cancel(false);
        }
        return currentTask;
    }
}

