/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.filestore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.useradmin.filestore.ResettableTimer;
import org.apache.felix.useradmin.filestore.RoleRepositoryMemoryStore;
import org.apache.felix.useradmin.filestore.RoleRepositorySerializer;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.useradmin.UserAdminEvent;
import org.osgi.service.useradmin.UserAdminListener;

public class RoleRepositoryFileStore
extends RoleRepositoryMemoryStore
implements Runnable,
UserAdminListener,
ManagedService {
    public static final String PID = "org.apache.felix.useradmin.filestore";
    static final String KEY_WRITE_DISABLED = "background.write.disabled";
    static final String KEY_WRITE_DELAY_VALUE = "background.write.delay.value";
    static final String KEY_WRITE_DELAY_TIMEUNIT = "background.write.delay.timeunit";
    private static final String PREFIX = "org.apache.felix.useradmin.filestore".concat(".");
    private static final boolean DEFAULT_WRITE_DISABLED = Boolean.parseBoolean(System.getProperty(PREFIX.concat("background.write.disabled"), "false"));
    private static final int DEFAULT_WRITE_DELAY_VALUE = Integer.parseInt(System.getProperty(PREFIX.concat("background.write.delay.value"), "500"));
    private static final TimeUnit DEFAULT_WRITE_DELAY_TIMEUNIT = TimeUnit.MILLISECONDS;
    private static final String FILE_NAME = "ua_repo.dat";
    private final File m_file;
    private final AtomicReference m_timerRef;

    public RoleRepositoryFileStore(File baseDir) {
        this(baseDir, !DEFAULT_WRITE_DISABLED);
    }

    public RoleRepositoryFileStore(File baseDir, boolean backgroundWriteEnabled) {
        this.m_file = new File(baseDir, FILE_NAME);
        this.m_timerRef = new AtomicReference();
        if (backgroundWriteEnabled) {
            this.m_timerRef.set(new ResettableTimer(this, DEFAULT_WRITE_DELAY_VALUE, DEFAULT_WRITE_DELAY_TIMEUNIT));
        }
    }

    public void roleChanged(UserAdminEvent event) {
        this.scheduleTask();
    }

    public void run() {
        try {
            this.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void start() throws IOException {
        this.m_entries.putAll(this.retrieve());
    }

    public void stop() throws IOException {
        ResettableTimer timer = (ResettableTimer)this.m_timerRef.get();
        if (timer != null) {
            if (!timer.isShutDown()) {
                timer.shutDown();
            }
            this.m_timerRef.compareAndSet(timer, null);
        }
        this.flush();
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        ResettableTimer timer;
        boolean writeDisabled = DEFAULT_WRITE_DISABLED;
        int writeDelayValue = DEFAULT_WRITE_DELAY_VALUE;
        TimeUnit writeDelayUnit = DEFAULT_WRITE_DELAY_TIMEUNIT;
        if (properties != null) {
            Object wd = properties.get(KEY_WRITE_DISABLED);
            if (wd == null) {
                throw new ConfigurationException(KEY_WRITE_DISABLED, "Missing write disabled value!");
            }
            try {
                writeDisabled = Boolean.parseBoolean((String)wd);
            }
            catch (Exception e) {
                throw new ConfigurationException(KEY_WRITE_DISABLED, "Invalid write disabled value!");
            }
            if (!writeDisabled) {
                Object wdv = properties.get(KEY_WRITE_DELAY_VALUE);
                if (wdv == null) {
                    throw new ConfigurationException(KEY_WRITE_DELAY_VALUE, "Missing write delay value!");
                }
                try {
                    writeDelayValue = Integer.parseInt((String)wdv);
                }
                catch (Exception e) {
                    throw new ConfigurationException(KEY_WRITE_DELAY_VALUE, "Invalid write delay value!");
                }
                if (writeDelayValue <= 0) {
                    throw new ConfigurationException(KEY_WRITE_DELAY_VALUE, "Invalid write delay value!");
                }
                Object wdu = properties.get(KEY_WRITE_DELAY_TIMEUNIT);
                if (wdu != null) {
                    try {
                        writeDelayUnit = TimeUnit.valueOf(((String)wdu).toUpperCase());
                    }
                    catch (Exception e) {
                        throw new ConfigurationException(KEY_WRITE_DELAY_TIMEUNIT, "Invalid write delay unit!");
                    }
                }
            }
        }
        if ((timer = (ResettableTimer)this.m_timerRef.get()) != null) {
            timer.shutDown();
        }
        this.m_timerRef.compareAndSet(timer, writeDisabled ? null : new ResettableTimer(this, writeDelayValue, writeDelayUnit));
    }

    /*
     * Loose catch block
     */
    protected Map retrieve() throws IOException {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(this.m_file));
            Map map = new RoleRepositorySerializer().deserialize(is);
            this.closeSafely(is);
            return map;
        }
        catch (FileNotFoundException exception) {
            Map map = Collections.emptyMap();
            return map;
        }
        catch (IOException exception2) {
            exception2.printStackTrace();
            throw exception2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.closeSafely(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(Map roleRepository) throws IOException {
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(this.m_file));
            new RoleRepositorySerializer().serialize(roleRepository, os);
            this.closeSafely(os);
        }
        catch (Throwable throwable) {
            this.closeSafely(os);
            throw throwable;
        }
    }

    private void closeSafely(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void flush() throws IOException {
        this.store(new HashMap(this.m_entries));
    }

    private void scheduleTask() {
        ResettableTimer timer = (ResettableTimer)this.m_timerRef.get();
        if (timer != null && !timer.isShutDown()) {
            timer.schedule();
        }
    }
}

