/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.useradmin.RoleRepositoryStore;
import org.apache.felix.useradmin.mongodb.MongoDB;
import org.apache.felix.useradmin.mongodb.MongoSerializerHelper;
import org.apache.felix.useradmin.mongodb.RoleProvider;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.UserAdminEvent;
import org.osgi.service.useradmin.UserAdminListener;

public class MongoDBStore
implements RoleProvider,
RoleRepositoryStore,
UserAdminListener,
ManagedService {
    public static final String PID = "org.apache.felix.useradmin.mongodb";
    private static final String KEY_MONGODB_SERVER = "server";
    private static final String KEY_MONGODB_DBNAME = "dbname";
    private static final String KEY_MONGODB_USERNAME = "username";
    private static final String KEY_MONGODB_PASSWORD = "password";
    private static final String KEY_MONGODB_COLLECTION_NAME = "collection";
    private static final String PREFIX = "org.apache.felix.useradmin.mongodb".concat(".");
    private static final String DEFAULT_MONGODB_SERVER = System.getProperty(PREFIX.concat("server"), "localhost:27017");
    private static final String DEFAULT_MONGODB_DBNAME = System.getProperty(PREFIX.concat("dbname"), "ua_repo");
    private static final String DEFAULT_MONGODB_COLLECTION = System.getProperty(PREFIX.concat("collection"), "useradmin");
    private static final String DEFAULT_MONGODB_USERNAME = System.getProperty(PREFIX.concat("username"));
    private static final String DEFAULT_MONGODB_PASSWORD = System.getProperty(PREFIX.concat("password"));
    private final AtomicReference<MongoDB> m_mongoDbRef = new AtomicReference();
    private final MongoSerializerHelper m_helper = new MongoSerializerHelper(this);
    private volatile LogService m_log;

    public Role addRole(String roleName, int type) throws MongoException {
        if (roleName == null) {
            throw new IllegalArgumentException("Role cannot be null!");
        }
        DBCollection coll = this.getCollection();
        Role role = this.getRole(roleName);
        if (role != null) {
            return null;
        }
        DBObject data = this.m_helper.serialize(roleName, type);
        WriteResult result = coll.insert(new DBObject[]{data});
        if (result.getLastError() != null) {
            result.getLastError().throwOnError();
        }
        return role;
    }

    public void close() {
        MongoDB mongoDB = this.m_mongoDbRef.get();
        if (mongoDB != null) {
            mongoDB.disconnect();
        }
        this.m_mongoDbRef.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Role[] getRoles(String filterValue) throws InvalidSyntaxException, MongoException {
        ArrayList<Role> roles = new ArrayList<Role>();
        Filter filter = null;
        if (filterValue != null) {
            filter = FrameworkUtil.createFilter((String)filterValue);
        }
        DBCollection coll = this.getCollection();
        DBCursor cursor = coll.find();
        try {
            while (cursor.hasNext()) {
                Role role = this.m_helper.deserialize(cursor.next());
                if (filter != null && !filter.match(role.getProperties())) continue;
                roles.add(role);
            }
        }
        finally {
            cursor.close();
        }
        return roles.toArray(new Role[roles.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role getRole(String name) {
        DBCollection coll = this.getCollection();
        DBCursor cursor = coll.find(this.getTemplateObject(name));
        try {
            if (cursor.hasNext()) {
                Role role = this.m_helper.deserialize(cursor.next());
                return role;
            }
        }
        finally {
            cursor.close();
        }
        return null;
    }

    public Role getRoleByName(String name) throws MongoException {
        return this.getRole(name);
    }

    public Role removeRole(String roleName) throws MongoException {
        DBCollection coll = this.getCollection();
        Role role = this.getRole(roleName);
        if (role == null) {
            return null;
        }
        WriteResult result = coll.remove(this.getTemplateObject(role));
        if (result.getLastError() != null) {
            result.getLastError().throwOnError();
        }
        return role;
    }

    public void roleChanged(UserAdminEvent event) {
        if (2 == event.getType()) {
            Role changedRole = event.getRole();
            try {
                DBCollection coll = this.getCollection();
                DBObject query = this.getTemplateObject(changedRole);
                DBObject update = this.m_helper.serializeUpdate(changedRole);
                WriteResult result = coll.update(query, update, false, false);
                if (result.getLastError() != null) {
                    result.getLastError().throwOnError();
                }
            }
            catch (MongoException e) {
                this.m_log.log(2, "Failed to update changed role: " + changedRole.getName(), (Throwable)e);
            }
        }
    }

    public void setLogService(LogService log) {
        this.m_log = log;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        MongoDB oldMongoDb;
        String newDbName = this.getProperty(properties, KEY_MONGODB_DBNAME, DEFAULT_MONGODB_DBNAME);
        String newServers = this.getProperty(properties, KEY_MONGODB_SERVER, DEFAULT_MONGODB_SERVER);
        String newCollectionName = this.getProperty(properties, KEY_MONGODB_COLLECTION_NAME, DEFAULT_MONGODB_COLLECTION);
        String newUsername = this.getProperty(properties, KEY_MONGODB_USERNAME, DEFAULT_MONGODB_USERNAME);
        String newPassword = this.getProperty(properties, KEY_MONGODB_PASSWORD, DEFAULT_MONGODB_PASSWORD);
        MongoDB newMongoDb = new MongoDB(newServers, newDbName, newCollectionName);
        while (!this.m_mongoDbRef.compareAndSet(oldMongoDb = this.m_mongoDbRef.get(), newMongoDb)) {
        }
        try {
            if (oldMongoDb != null) {
                oldMongoDb.disconnect();
            }
        }
        catch (MongoException e) {
            this.m_log.log(2, "Failed to disconnect from (old) MongoDB!", (Throwable)e);
        }
        try {
            this.connectToDB(newMongoDb, newUsername, newPassword);
        }
        catch (MongoException e) {
            this.m_log.log(2, "Failed to connect to (new) MongoDB!", (Throwable)e);
            throw new ConfigurationException(DEFAULT_MONGODB_USERNAME, "Failed to connect!", (Throwable)e);
        }
    }

    private void connectToDB(MongoDB mongoDB, String userName, String password) throws MongoException {
        if (!mongoDB.connect(userName, password)) {
            throw new MongoException("Failed to connect to MongoDB! Authentication failed!");
        }
        DBCollection collection = mongoDB.getCollection();
        if (collection == null) {
            throw new MongoException("Failed to connect to MongoDB! No collection returned!");
        }
        collection.ensureIndex((DBObject)new BasicDBObject("name", (Object)1).append("unique", (Object)true));
    }

    private DBCollection getCollection() {
        MongoDB mongoDB = this.m_mongoDbRef.get();
        if (mongoDB == null) {
            throw new MongoException("No connection to MongoDB?!");
        }
        return mongoDB.getCollection();
    }

    private String getProperty(Dictionary properties, String key, String defaultValue) {
        Object value;
        String result = defaultValue;
        if (properties != null && (value = properties.get(key)) != null && value instanceof String) {
            result = (String)value;
        }
        return result;
    }

    private DBObject getTemplateObject(Role role) {
        BasicDBObject query = new BasicDBObject();
        query.put("name", (Object)role.getName());
        query.put("type", (Object)role.getType());
        return query;
    }

    private DBObject getTemplateObject(String name) {
        BasicDBObject query = new BasicDBObject();
        query.put("name", (Object)name);
        return query;
    }
}

