/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineTag;
import flash.util.StringJoiner;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SymbolTable;
import flex2.compiler.common.Configuration;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Digest;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.Name;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.PreLink;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompcPreLink
implements flex2.compiler.PreLink {
    private static final String DEFAULTS = "defaults";
    private static final String DOT_CSS = ".css";
    private boolean hidePotentialMissingSkinsWarning;
    private Map<String, VirtualFile> rbFiles;
    private List<String> defaults;

    public CompcPreLink(Map<String, VirtualFile> rbFiles, List<String> defaults, boolean hidePotentialMissingSkinsWarning) {
        this.rbFiles = rbFiles;
        this.defaults = defaults;
        this.hidePotentialMissingSkinsWarning = hidePotentialMissingSkinsWarning;
    }

    @Override
    public boolean run(List<Source> sources, List<CompilationUnit> units, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceBundlePath bundlePath, ResourceContainer resources, SymbolTable symbolTable, CompilerSwcContext swcContext, NameMappings nameMappings, Configuration configuration) {
        this.postGenerateExtraSwcCode(sources, units, symbolTable, sourceList, sourcePath, bundlePath, resources, swcContext, configuration);
        this.processResourceBundles(this.rbFiles, configuration, sources, this.defaults, symbolTable, bundlePath, swcContext);
        return false;
    }

    @Override
    public void postRun(List<Source> sources, List<CompilationUnit> units, ResourceContainer resources, SymbolTable symbolTable, CompilerSwcContext swcContext, NameMappings nameMappings, Configuration configuration) {
        int highestMinimumSupportedVersion = 0x3000000;
        boolean isMinimumSupportedVersionConfigured = configuration.getCompilerConfiguration().getMxmlConfiguration().isMinimumSupportedVersionConfigured();
        HashSet<String> processedSwcs = new HashSet<String>();
        Set<String> externs = configuration.getExterns();
        for (CompilationUnit u : units) {
            SwcScript swcScript;
            Swc swc;
            String location;
            Object message;
            HashSet<Name> dependencies = new HashSet<Name>();
            dependencies.addAll(u.inheritance);
            dependencies.addAll(u.namespaces);
            dependencies.addAll(u.expressions);
            dependencies.addAll(u.types);
            for (Name name : dependencies) {
                SwcScript swcScript2;
                Swc swc2;
                Source dependent;
                if (!(name instanceof QName) || (dependent = symbolTable.findSourceByQName((QName)name)) == null || !dependent.isSwcScriptOwner() || highestMinimumSupportedVersion >= (swc2 = (swcScript2 = (SwcScript)dependent.getOwner()).getLibrary().getSwc()).getVersions().getMinimumVersion() || !configuration.getCompilerConfiguration().enableSwcVersionFiltering()) continue;
                highestMinimumSupportedVersion = swc2.getVersions().getMinimumVersion();
                if (!isMinimumSupportedVersionConfigured || configuration.getMinimumSupportedVersion() >= highestMinimumSupportedVersion) continue;
                message = new HigherMinimumSupportedVersionRequired(swc2.getLocation(), swc2.getVersions().getMinimumVersionString());
                ThreadLocalToolkit.log((CompilerMessage)message, u.getSource());
            }
            Source source = u.getSource();
            if (!source.isSwcScriptOwner() || PreLink.isCompilationUnitExternal(u, externs) || source.isInternal() || this.hidePotentialMissingSkinsWarning || processedSwcs.contains(location = (swc = (swcScript = (SwcScript)source.getOwner()).getLibrary().getSwc()).getLocation())) continue;
            processedSwcs.add(location);
            boolean foundDefaultsCss = false;
            for (VirtualFile catalogFile : swc.getCatalogFiles().values()) {
                String catalogFileName = catalogFile.getName();
                int dollarSignIndex = catalogFileName.indexOf("$");
                if (dollarSignIndex == -1 || !catalogFileName.startsWith(DEFAULTS, dollarSignIndex + 1) || !catalogFileName.endsWith(DOT_CSS)) continue;
                foundDefaultsCss = true;
            }
            if (!foundDefaultsCss) continue;
            message = new PotentialForMissingSkins(swc.getLocation());
            ThreadLocalToolkit.log((ILocalizableMessage)message);
        }
        if (!isMinimumSupportedVersionConfigured) {
            configuration.getCompilerConfiguration().getMxmlConfiguration().setMinimumSupportedVersion(highestMinimumSupportedVersion);
        }
    }

    private void postGenerateExtraSwcCode(List<Source> sources, List units, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceBundlePath bundlePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        int size;
        LinkedList<DefineTag> fonts = new LinkedList<DefineTag>();
        boolean isAccessible = configuration.getCompilerConfiguration().accessible();
        HashSet<String> accessibilityList = new HashSet<String>();
        Set<String> externs = configuration.getExterns();
        ArrayList<Long> checksumList = new ArrayList<Long>(units.size());
        int n = size = units == null ? 0 : units.size();
        for (int i = 0; i < size; ++i) {
            List<DefineFont> fontList;
            Set<String> unitAccessibilityList;
            CompilationUnit u = (CompilationUnit)units.get(i);
            if (u == null || PreLink.isCompilationUnitExternal(u, externs) || u.getSource().isInternal()) continue;
            if (isAccessible && (unitAccessibilityList = u.getAccessibilityClasses()) != null) {
                accessibilityList.addAll(unitAccessibilityList);
            }
            if (u.hasAssets() && (fontList = u.getAssets().getFonts()) != null && !fontList.isEmpty()) {
                fonts.addAll(fontList);
            }
            if (u.getSignatureChecksum() == null) continue;
            checksumList.add(u.getSignatureChecksum());
        }
        if (accessibilityList.size() > 0) {
            for (String className : accessibilityList) {
                MultiName mName = new MultiName(NameFormatter.retrievePackageName(className), NameFormatter.retrieveClassName(className));
                CompilerAPI.resolveMultiName(mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
            }
        }
        StringBuffer checksumBuffer = new StringBuffer();
        Collections.sort(checksumList);
        for (Long checksum : checksumList) {
            checksumBuffer.append(checksum);
        }
        String uniqueRootClassName = new Digest().computeDigest(checksumBuffer.toString().getBytes());
        this.codegenRootClass(sources, units, resources, swcContext, configuration, fonts, uniqueRootClassName);
    }

    private void processResourceBundles(Map<String, VirtualFile> rbFiles, Configuration configuration, List<Source> sources, List<String> defaults, SymbolTable symbolTable, ResourceBundlePath bundlePath, CompilerSwcContext swcContext) {
        if (rbFiles != null && !configuration.generateRBList()) {
            int i;
            String[] locales = configuration.getCompilerConfiguration().getLocales();
            TreeSet<String> s = new TreeSet<String>();
            Set<String> externs = configuration.getExterns();
            int size = sources.size();
            for (i = 0; i < size; ++i) {
                CompilationUnit unit;
                Source src = sources.get(i);
                CompilationUnit compilationUnit = unit = src == null ? null : src.getCompilationUnit();
                if (unit == null || PreLink.isCompilationUnitExternal(unit, externs) || src.isInternal()) continue;
                s.addAll(unit.resourceBundleHistory);
            }
            int n = size = defaults == null ? 0 : defaults.size();
            for (i = 0; i < size; ++i) {
                s.add(defaults.get(i));
            }
            Iterator i2 = s.iterator();
            while (i2.hasNext()) {
                int size2;
                QName precompiledQName;
                Source source;
                String rbName = NameFormatter.toColon((String)i2.next());
                QName qName = new QName(rbName);
                VirtualFile[] files = bundlePath.findVirtualFiles(rbName);
                if (files == null) {
                    files = swcContext.getVirtualFiles(locales, qName.getNamespace(), qName.getLocalPart());
                }
                if (files == null && (source = swcContext.getSource((precompiledQName = new QName(rbName + I18nUtils.CLASS_SUFFIX)).getNamespace(), precompiledQName.getLocalPart())) != null) {
                    externs.add((String)((Object)qName));
                    continue;
                }
                if (files == null && locales.length > 0) {
                    ThreadLocalToolkit.log(new SwcException.NoResourceBundleSource(rbName));
                }
                int n2 = size2 = files == null ? 0 : files.length;
                for (int j = 0; j < size2; ++j) {
                    if (files[j] == null) continue;
                    String ext = MimeMappings.getExtension(files[j].getMimeType());
                    String key = "locale/" + locales[j] + "/" + rbName.replace(':', '.').replace('.', '/') + ext;
                    rbFiles.put(key, files[j]);
                }
                if (files == null) continue;
                QName[] qNames = CompilerAPI.resolveResourceBundleName(rbName, sources, null, bundlePath, null, swcContext, symbolTable, locales);
                configuration.addExterns(qNames);
            }
        }
    }

    private void codegenRootClass(List<Source> sources, List units, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration, List<DefineTag> fonts, String uniqueRootClassName) {
        String rootClassName = "_" + uniqueRootClassName + "_";
        String sourceText = null;
        if (fonts.size() == 0) {
            rootClassName = rootClassName + "flash_display_Sprite";
            sourceText = CompcPreLink.codegenRSLRootClass("flash.display.Sprite", rootClassName);
        } else {
            rootClassName = rootClassName + "mx_core_FlexModuleFactory";
            sourceText = PreLink.codegenModuleFactory("flash.display.Sprite", rootClassName, null, null, null, null, null, null, null, fonts, null, null, null, null, configuration, null, swcContext, true);
        }
        String generatedLoaderFile = rootClassName + ".as";
        Source s = new Source((VirtualFile)new TextFile(sourceText, generatedLoaderFile, null, MimeMappings.getMimeType(generatedLoaderFile)), "", rootClassName, null, false, false, false);
        s.setPathResolver(null);
        sources.add(resources.addResource(s));
        configuration.setRootClassName(rootClassName);
        if (configuration.getCompilerConfiguration().keepGeneratedActionScript()) {
            PreLink.saveGenerated(generatedLoaderFile, sourceText, configuration.getCompilerConfiguration().getGeneratedDirectory());
        }
    }

    private String getSwcClassName(String pathName) {
        File file = new File(pathName);
        String fileName = file.getName();
        int ext = fileName.lastIndexOf(".");
        if (ext != -1) {
            fileName = fileName.substring(0, ext);
        }
        fileName = fileName.replaceAll("[\\W]", "_");
        return fileName;
    }

    private static String codegenRSLRootClass(String base, String rootClassName) {
        String lineSep = System.getProperty("line.separator");
        Object[] codePieces = new String[]{"package", lineSep, "{", lineSep, lineSep, "import flash.display.Sprite;", lineSep, "import flash.system.Security;", lineSep, lineSep, "/**", lineSep, " *  @private", lineSep, " */", lineSep, "[ExcludeClass]", lineSep, "public class ", rootClassName, lineSep, "    extends ", base, lineSep, "{", lineSep, "    public function ", rootClassName, "()", lineSep, "    {", lineSep, "        super();", lineSep, "    }", lineSep, lineSep, PreLink.codegenRSLSecurityWrapper(true, lineSep), "}", lineSep, lineSep, "}", lineSep};
        return StringJoiner.join((Object[])codePieces, null);
    }

    public static class PotentialForMissingSkins
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -917715346261180365L;
        public String swc;

        public PotentialForMissingSkins(String swc) {
            this.swc = swc;
        }
    }

    public static class HigherMinimumSupportedVersionRequired
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -917715346261180364L;
        public String swc;
        public String swcMinimumSupportedVersion;

        public HigherMinimumSupportedVersionRequired(String swc, String swcMinimumSupportedVersion) {
            this.swc = swc;
            this.swcMinimumSupportedVersion = swcMinimumSupportedVersion;
        }
    }
}

