/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.sax;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.FXGParser;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.sax.FXGSAXScanner;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FXGSAXParser
implements FXGParser {
    private FXGSAXScanner scanner = null;

    public FXGSAXParser(String profile) {
        this.scanner = this.createScanner(profile);
    }

    @Override
    public FXGNode parse(InputStream stream) throws FXGException, IOException {
        return this.parse(stream, null);
    }

    @Override
    public FXGNode parse(InputStream stream, String documentName) throws FXGException, IOException {
        try {
            FXGNode node;
            this.scanner.setDocumentName(documentName);
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setValidating(false);
            saxFactory.setNamespaceAware(true);
            SAXParser parser = saxFactory.newSAXParser();
            parser.parse(stream, (DefaultHandler)this.scanner);
            FXGNode fXGNode = node = this.scanner.getRootNode();
            return fXGNode;
        }
        catch (ParserConfigurationException ex) {
            throw new FXGException(this.scanner.getStartLine(), this.scanner.getStartColumn(), "ErrorParsingFXG", ex.getLocalizedMessage(), ex);
        }
        catch (SAXException ex) {
            throw new FXGException(this.scanner.getStartLine(), this.scanner.getStartColumn(), "ErrorParsingFXG", ex.getLocalizedMessage(), ex);
        }
        finally {
            stream.close();
        }
    }

    @Override
    public void registerElementNode(double version, String uri, String localName, Class<? extends FXGNode> nodeClass) {
        this.scanner.registerElementNode(version, uri, localName, nodeClass);
    }

    @Override
    public void skipElement(double version, String uri, String localName) {
        this.scanner.skipElement(version, uri, localName);
    }

    protected FXGSAXScanner createScanner(String profile) {
        return new FXGSAXScanner(profile);
    }
}

