/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.launcher.commands.player;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.flexunit.ant.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustFile {
    public static final String TRUST_FILENAME = "flexUnit.cfg";
    private File trustDirectory;
    private File trustFile;
    private List<String> paths;

    public TrustFile(Project project, File file, File file2) {
        File file3 = this.trustDirectory = file != null ? file : file2;
        if (!this.trustDirectory.exists()) {
            try {
                this.trustDirectory.mkdirs();
            }
            catch (Exception exception) {
                throw new BuildException("Could not create Flash Player trust directory at [" + this.trustDirectory.getAbsolutePath() + "]; permission denied.");
            }
        }
        this.trustFile = project.resolveFile(this.trustDirectory.getAbsolutePath() + "/" + TRUST_FILENAME);
        this.paths = this.read();
    }

    private List<String> read() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.trustFile.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.trustFile));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    arrayList.add(string);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    public void add(String string) {
        String string2 = new File(string).getParentFile().getAbsolutePath();
        this.addPath(string2);
    }

    public void add(File file) {
        String string = file.getParentFile().getAbsolutePath();
        this.addPath(string);
    }

    private void addPath(String string) {
        if (!this.trustDirectory.exists()) {
            this.trustDirectory.mkdir();
        }
        if (!this.paths.contains(string)) {
            this.paths.add(string);
            this.write();
            LoggingUtil.log("Updated local trust file at [" + this.trustFile.getAbsolutePath() + "], added [" + string + "].");
        } else {
            LoggingUtil.log("Entry [" + string + "] already available in local trust file at [" + this.trustFile.getAbsolutePath() + "].");
        }
    }

    private void write() {
        try {
            FileWriter fileWriter = new FileWriter(this.trustFile, false);
            for (String string : this.paths) {
                fileWriter.write(string + System.getProperty("line.separator"));
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void remove(String string) {
        String string2 = new File(string).getParentFile().getAbsolutePath();
        this.removePath(string2);
    }

    public void remove(File file) {
        String string = file.getParentFile().getAbsolutePath();
        this.removePath(string);
    }

    public void removePath(String string) {
        if (this.paths.contains(string)) {
            this.paths.remove(string);
            this.write();
            LoggingUtil.log("Updated local trust file at [" + this.trustFile.getAbsolutePath() + "], removed [" + string + "].");
        }
    }
}

