/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.tvf.operator;

import java.time.ZoneId;
import java.util.Collection;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.GroupWindowAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.operator.WindowTableFunctionOperatorBase;
import org.apache.flink.table.runtime.util.TimeWindowUtil;

public class AlignedWindowTableFunctionOperator
extends WindowTableFunctionOperatorBase {
    private static final long serialVersionUID = 1L;

    public AlignedWindowTableFunctionOperator(GroupWindowAssigner<TimeWindow> windowAssigner, int rowtimeIndex, ZoneId shiftTimeZone) {
        super(windowAssigner, rowtimeIndex, shiftTimeZone);
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        long timestamp;
        RowData inputRow = (RowData)element.getValue();
        if (this.windowAssigner.isEventTime()) {
            if (inputRow.isNullAt(this.rowtimeIndex)) {
                this.numNullRowTimeRecordsDropped.inc();
                return;
            }
            timestamp = inputRow.getTimestamp(this.rowtimeIndex, 3).getMillisecond();
        } else {
            timestamp = this.getProcessingTimeService().getCurrentProcessingTime();
        }
        timestamp = TimeWindowUtil.toUtcTimestampMills(timestamp, this.shiftTimeZone);
        Collection<TimeWindow> elementWindows = this.windowAssigner.assignWindows(inputRow, timestamp);
        this.collect(inputRow, elementWindows);
    }
}

